import React from 'react'
import { Card, CardContent } from './ui/card'

function formatNumber(n: number) {
  return new Intl.NumberFormat('fr-FR').format(n)
}

export default function KpiStrip({ metrics }: { metrics: { label: string; value: number; delta?: number }[] }) {
  return (
    <div className="grid grid-cols-1 md:grid-cols-3 gap-3 mb-4">
      {metrics.map((m) => (
        <Card key={m.label}>
          <CardContent>
            <div className="text-xs text-slate-500 dark:text-slate-300">{m.label}</div>
            <div className="text-2xl font-semibold">{formatNumber(m.value)}</div>
            {m.delta !== undefined && (
              <div className={(m.delta >= 0 ? 'text-emerald-600' : 'text-rose-600') + ' text-xs'}>
                {m.delta >= 0 ? `+${(m.delta * 100).toFixed(1)}%` : `${(m.delta * 100).toFixed(1)}%`}
              </div>
            )}
          </CardContent>
        </Card>
      ))}
    </div>
  )
}
