<?php

namespace App\tests\Api;

use ApiPlatform\Symfony\Bundle\Test\ApiTestCase;
use App\Factory\TypeTaxeFactory;

class TypeTaxeTest extends ApiTestCase
{
    public function testGetTypeTaxeCollection(): void
    {
        // Remplace '/api/taxes' par l'URL réelle de ta ressource API
        $response = static::createClient()->request('GET', '/type_taxes');

        $this->assertResponseIsSuccessful();

        // Vérifie que c'est du JSON-LD (standard API Platform)
        $this->assertJsonContains([
            '@type' => 'Collection',
        ]);
    }

    public function testGetTypeTaxe(): void
    {
        $typeTaxe = TypeTaxeFactory::createOne();

        $response = static::createClient()->request('GET', '/type_taxes/' . $typeTaxe->getId());

        $this->assertResponseIsSuccessful();

        $this->assertJsonContains([
            'id' => $typeTaxe->getId(),
        ]);

    }
}
{

}
