<?php

namespace App\Factory;

use App\Entity\Taxe;
use Zenstruck\Foundry\Persistence\PersistentObjectFactory;

/**
 * @extends PersistentObjectFactory<Taxe>
 */
final class TaxeFactory extends PersistentObjectFactory
{
    #[\Override]
    public static function class(): string
    {
        return Taxe::class;
    }

    /**
     * @see https://symfony.com/bundles/ZenstruckFoundryBundle/current/index.html#model-factories
     *
     */
    #[\Override]
    protected function defaults(): array|callable
    {
        return [
            'annee' => self::faker()->randomNumber(),
            'commune' => CommuneFactory::new(),
            'taux' => self::faker()->randomFloat(),
            'type' => TypeTaxeFactory::new(),
            'volume' => self::faker()->randomFloat(),
        ];
    }

    /**
     * @see https://symfony.com/bundles/ZenstruckFoundryBundle/current/index.html#initialization
     */
    #[\Override]
    protected function initialize(): static
    {
        return $this
            // ->afterInstantiate(function(Taxe $taxe): void {})
        ;
    }
}
