// Generated mock data based on api entities: Region, Departement, Commune, TypeTaxe, Taxe

export const regions = [
  { id: 1, nom: 'Ile-de-France' },
  { id: 2, nom: 'Auvergne-Rhône-Alpes' },
  { id: 3, nom: 'Nouvelle-Aquitaine' },
  { id: 4, nom: 'Occitanie' },
  { id: 5, nom: 'Provence-Alpes-Côte d\'Azur' },
  { id: 6, nom: 'Hauts-de-France' }
];

export const departements = [
  { id: 1, code: 75, nom: 'Paris', regionId: 1 },
  { id: 2, code: 92, nom: 'Hauts-de-Seine', regionId: 1 },
  { id: 3, code: 69, nom: 'Rhône', regionId: 2 },
  { id: 4, code: 33, nom: 'Gironde', regionId: 3 },
  { id: 5, code: 31, nom: 'Haute-Garonne', regionId: 4 },
  { id: 6, code: 13, nom: 'Bouches-du-Rhône', regionId: 5 },
  { id: 7, code: 59, nom: 'Nord', regionId: 6 },
  { id: 8, code: 62, nom: 'Pas-de-Calais', regionId: 6 },
  { id: 9, code: 6, nom: 'Alpes-Maritimes', regionId: 5 },
  { id: 10, code: 42, nom: 'Loire', regionId: 2 },
  { id: 11, code: 76, nom: 'Seine-Maritime', regionId: 6 },
  { id: 12, code: 34, nom: 'Hérault', regionId: 4 }
];

export const communes = [
  { id: 1, code: 75056, nom: 'Paris', departementId: 1 },
  { id: 2, code: 92050, nom: 'Nanterre', departementId: 2 },
  { id: 3, code: 92218, nom: 'Boulogne-Billancourt', departementId: 2 },
  { id: 4, code: 69123, nom: 'Lyon 1er', departementId: 3 },
  { id: 5, code: 69124, nom: 'Lyon 2e', departementId: 3 },
  { id: 6, code: 69381, nom: 'Vaulx-en-Velin', departementId: 3 },
  { id: 7, code: 33063, nom: 'Bordeaux', departementId: 4 },
  { id: 8, code: 33152, nom: 'Mérignac', departementId: 4 },
  { id: 9, code: 31069, nom: 'Toulouse', departementId: 5 },
  { id: 10, code: 31320, nom: 'Aucamville', departementId: 5 },
  { id: 11, code: 13055, nom: 'Marseille', departementId: 6 },
  { id: 12, code: 13116, nom: 'Aix-en-Provence', departementId: 6 },
  { id: 13, code: 59350, nom: 'Saint-André-lez-Lille', departementId: 7 },
  { id: 14, code: 59009, nom: 'Armentières', departementId: 7 },
  { id: 15, code: 62041, nom: 'Arras', departementId: 8 },
  { id: 16, code: 60088, nom: 'Nice', departementId: 9 },
  { id: 17, code: 42095, nom: 'Saint-Étienne', departementId: 10 },
  { id: 18, code: 76351, nom: 'Le Havre', departementId: 11 },
  { id: 19, code: 34172, nom: 'Sète', departementId: 12 },
  { id: 20, code: 34172, nom: 'Montpellier', departementId: 12 },
  { id: 21, code: 33002, nom: 'Ambarès-et-Lagrave', departementId: 4 },
  { id: 22, code: 31001, nom: 'Aigrefeuille', departementId: 5 },
  { id: 23, code: 69123, nom: 'Caluire-et-Cuire', departementId: 3 },
  { id: 24, code: 75057, nom: 'Versailles', departementId: 1 },
  { id: 25, code: 92064, nom: 'Suresnes', departementId: 2 },
  { id: 26, code: 13001, nom: 'Salon-de-Provence', departementId: 6 },
  { id: 27, code: 59390, nom: 'Lille', departementId: 7 },
  { id: 28, code: 62219, nom: 'Boulogne-sur-Mer', departementId: 8 },
  { id: 29, code: 6037, nom: 'Cannes', departementId: 9 },
  { id: 30, code: 34172, nom: 'Lattes', departementId: 12 }
];

export const typeTaxes = [
  { id: 1, code: 'TFPNB', label: 'Taxe Foncière sur les Propriétés Non Bâties' },
  { id: 2, code: 'TFPB', label: 'Taxe Foncière sur les Propriétés Bâties' },
  { id: 3, code: 'TH', label: 'Taxe d\'Habitation' },
  { id: 4, code: 'CFE', label: 'Cotisation Foncière des Entreprises' }
];

// generate sample taxes programmatically to provide richer mock data
export const taxes = (() => {
  const rows: any[] = [];
  let id = 1;
  // expand years for a broader timeseries
  const years = [2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022, 2023, 2024];
  // produce several entries per commune per year across types for scatter richness
  for (const c of communes) {
    for (const y of years) {
      // produce 4 records per year (different type / sub-entries)
      for (let t = 0; t < 4; t++) {
        const typeId = ((c.id + t) % typeTaxes.length) + 1;
        // deterministic but varied base to mimic realistic spreads
        const base = (c.id * 97 + y * 41 + t * 23) % 5000;
        const taux = Number((0.002 + (base % 300) / 10000).toFixed(4));
        const volume = Number((base * (8 + (c.id % 5)) + (c.id * 20)).toFixed(2));
        rows.push({ id: id++, communeId: c.id, annee: y, typeId, taux, volume });
      }
    }
  }

  return rows;
})();

export default {
  regions,
  departements,
  communes,
  typeTaxes,
  taxes
};
