<?php

namespace App\State;

use ApiPlatform\Metadata\Operation;
use ApiPlatform\State\ProviderInterface;
use App\ApiResource\RegionVolumeStats;
use App\Repository\TaxeRepository;

class RegionVolumeStatsProvider implements ProviderInterface
{
    public function __construct(private TaxeRepository $taxeRepository)
    {
    }

    public function provide(Operation $operation, array $uriVariables = [], array $context = []): object|array|null
    {
        $filters = $context['filters'] ?? [];

        $year = isset($filters['year']) ? (int)$filters['year'] : 2022;
        $typeCode = $filters['typeCode'] ?? 'TFPNB';

        $results = $this->taxeRepository->findVolumesByRegion($year, $typeCode);

        $dtos = [];
        foreach ($results as $result) {
            $dtos[] = new RegionVolumeStats(
                $result['region'],
                (float)$result['totalVolume']
            );
        }

        return $dtos;
    }
}

