<?php

namespace App\DataFixtures;

use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Persistence\ObjectManager;
use PhpOffice\PhpSpreadsheet\IOFactory;

class AppFixtures extends Fixture
{
	public function __construct() {}

	const DATA_FILES = [
		'data/REI_2018.xlsx',
		'data/REI_COMPLET_2019.xlsx',
		'data/REI_COMPLET_2020.xlsx',
		'data/REI_2021.xlsx',
		'data/REI_2022.xlsx',
	];

	public function load(ObjectManager $manager): void {
		foreach (self::DATA_FILES as $path) {
			$annee = intval(end(explode('_', str_replace('.xlsx', '', $path))));

			$depNumCol = null;
			$comNumCol = null;
			$comNomCol = null;
			$tauxTFPNBCol = null;
			$volTFPNBCol = null;
			$tauxTFPBCol = null;
			$volTFPBCol = null;
			$tauxTHCol = null;
			$volTHCol = null;
			$tauxCFECol = null;
			$volCFECol = null;

			$colsFound = false;

			switch ($annee) {
				case 2018:
					# code...
					break;
				case 2019:
					# code...
					break;
				case 2020:
					# code...
					break;
				case 2021:
					# code...
					break;
				case 2022:
					$colsFound = true;

					$depNumCol = 1;
					$comNumCol = 3;
					$comNomCol = 10;
					$tauxTFPNBCol = 13;
					$volTFPNBCol = 14;
					$tauxTFPBCol = 68;
					$volTFPBCol = 69;
					$tauxTHCol = 332;
					$volTHCol = 333;
					$tauxCFECol = 175;
					$volCFECol = 176;
					break;
			}

			$reader = IOFactory::createReaderForFile($path);

			$sheet = $reader->load($path)->getActiveSheet();
			$highestRow = $sheet->getHighestDataRow(); // e.g. 10

			for ($row = 1; $row <= $highestRow; ++$row) {
				if(!$colsFound) { continue; }

				$depNum = $sheet->getCell([$depNumCol, $row])->getValue();
				$comNum = $sheet->getCell([$comNumCol, $row])->getValue();
				$comNom = $sheet->getCell([$comNomCol, $row])->getValue();
				$tauxTFPNB = $sheet->getCell([$tauxTFPNBCol, $row])->getValue();
				$volTFPNB = $sheet->getCell([$volTFPNBCol, $row])->getValue();
				$tauxTFPB = $sheet->getCell([$tauxTFPBCol, $row])->getValue();
				$volTFPB = $sheet->getCell([$volTFPBCol, $row])->getValue();
				$tauxTH = $sheet->getCell([$tauxTHCol, $row])->getValue();
				$volTH = $sheet->getCell([$volTHCol, $row])->getValue();
				$tauxCFE = $sheet->getCell([$tauxCFECol, $row])->getValue();
				$volCFE = $sheet->getCell([$volCFECol, $row])->getValue();
			}
		}
	}
}
