<?php

namespace App\ApiResource;

use ApiPlatform\Metadata\ApiProperty;
use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\GetCollection;
use ApiPlatform\OpenApi\Model\Operation;
use ApiPlatform\OpenApi\Model\Parameter;
use App\State\AverageTaxStatsProvider;

#[ApiResource(
    operations: [
        new GetCollection(
            uriTemplate: '/stats/average-tax-by-region',
            openapi: new Operation(
                summary: 'Récupère les taux moyens par région pour une plage d\'années et un type de taxe.',
                parameters: [
                    new Parameter(
                        name: 'startYear',
                        in: 'query',
                        description: 'Année de début',
                        required: true,
                        schema: ['type' => 'integer']
                    ),
                    new Parameter(
                        name: 'endYear',
                        in: 'query',
                        description: 'Année de fin',
                        required: true,
                        schema: ['type' => 'integer']
                    ),
                    new Parameter(
                        name: 'typeCode',
                        in: 'query',
                        description: 'Code du type de taxe (ex: TFPNB, TH...)',
                        required: true,
                        schema: ['type' => 'string']
                    ),
                ]
            ),
            provider: AverageTaxStatsProvider::class
        )
    ],
    paginationEnabled: false
)]
class AverageTaxStats
{
    #[ApiProperty(identifier: true)]
    public string $id;

    public function __construct(
        public string $region,
        public int $annee,
        public float $tauxMoyen
    ) {
        $this->id = $region . '-' . $annee;
    }
}
