<?php

namespace App\State;

use ApiPlatform\Metadata\Operation;
use ApiPlatform\State\ProviderInterface;
use App\ApiResource\AverageTaxStats;
use App\Repository\TaxeRepository;

class AverageTaxStatsProvider implements ProviderInterface
{
    public function __construct(private TaxeRepository $taxeRepository)
    {
    }

    public function provide(Operation $operation, array $uriVariables = [], array $context = []): object|array|null
    {
		ini_set('memory_limit', -1); // les fichiers excels sont tellement énormes qu'il faut beaucoup de RAM
        $filters = $context['filters'] ?? [];

        $startYear = isset($filters['startYear']) ? (int)$filters['startYear'] : 2018;
        $endYear = isset($filters['endYear']) ? (int)$filters['endYear'] : 2022;
        $typeCode = $filters['typeCode'] ?? 'TFPNB';

        $results = $this->taxeRepository->findAverageTauxByRegion($startYear, $endYear, $typeCode);

        $dtos = [];
        foreach ($results as $result) {
            $dtos[] = new AverageTaxStats(
                $result['region'],
                $result['annee'],
                (float)$result['tauxMoyen']
            );
        }

        return $dtos;
    }
}

