import { PieChart, Pie, Cell, Tooltip, Legend, ResponsiveContainer } from 'recharts';

export default function PieChartPanel({ data }: { data: { name: string; value: number }[] }) {
  const COLORS = ['#0B5FFF', '#00A78E', '#FFB020', '#6B21A8', '#475569'];

  return (
    <ResponsiveContainer width="100%" height={300}>
      <PieChart>
        <Pie data={data} dataKey="value" nameKey="name" innerRadius={50} outerRadius={100} fill="#8884d8" label />
        {data.map((_, idx) => (
          <Cell key={`cell-${idx}`} fill={COLORS[idx % COLORS.length]} />
        ))}
        <Tooltip formatter={(v: any) => new Intl.NumberFormat('fr-FR').format(v)} />
        <Legend />
      </PieChart>
    </ResponsiveContainer>
  );
}
