package edu.mermet.tp8.boite;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import edu.mermet.tp8.Application;
import edu.mermet.tp8.actions.ActionQuitter;
import edu.mermet.tp8.actions.ActionValider;
import edu.mermet.tp8.ecouteur.EcouteurConfig;
import edu.mermet.tp8.ecouteur.EcouteurConversion;

public class BoiteConfig extends JDialog{
	private JRadioButton autoConv, affichConv, cachConv;
	private JRadioButton autoTexte, affichTexte, cachTexte;
	private JRadioButton autoDiapo, affichDiapo, cachDiapo;
	private JRadioButton autoBouton, affichBouton, cachBouton;
	private Application a;
	
	public BoiteConfig(Application a) {
		super(a, "Configuration");
		this.a = a;
		init();
		pack();
		
		//this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
		//setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
		//this.setModal(true);
		this.setDefaultCloseOperation(HIDE_ON_CLOSE);
		this.addWindowListener(new EcouteurConfig(a.getActionConfig(), this));
		
	}
	
	public void init() {
		Container cont = this.getContentPane();
		BoxLayout box = new BoxLayout(cont, BoxLayout.Y_AXIS);
		
		cont.setLayout(box);
		//panel.setLayout(box);
		
		JPanel panel = new JPanel();
		JLabel conv = new JLabel("Conversion Celsius/Farenheit");
		ButtonGroup groupConv = new ButtonGroup();
		autoConv = new JRadioButton("Auto");
		//autoConv.setSelected(true);
		affichConv = new JRadioButton("Afficher");
		cachConv = new JRadioButton("Cacher");
		
		autoConv.setActionCommand("Auto");
		affichConv.setActionCommand("Afficher");
		cachConv.setActionCommand("Cacher");
		
		groupConv.add(autoConv);
		groupConv.add(affichConv);
		groupConv.add(cachConv);
		
		panel.add(conv);
		panel.add(autoConv);
		panel.add(affichConv);
		panel.add(cachConv);
		
		
		JPanel textP = new JPanel();
		JLabel textL = new JLabel("Saisie de texte");
		ButtonGroup groupText = new ButtonGroup();
		
		autoTexte = new JRadioButton("Auto");
		autoTexte.setSelected(true);
		affichTexte = new JRadioButton("Afficher");
		cachTexte = new JRadioButton("Cacher");
		
		autoTexte.setActionCommand("Auto");
		affichTexte.setActionCommand("Afficher");
		cachTexte.setActionCommand("Cacher");
		
		groupText.add(autoTexte);
		groupText.add(affichTexte);
		groupText.add(cachTexte);
		
		textP.add(textL);
		textP.add(autoTexte);
		textP.add(affichTexte);
		textP.add(cachTexte);
		
		
		JPanel diapoP = new JPanel();
		JLabel diapoL = new JLabel("Diaporama");
		ButtonGroup groupDiapo = new ButtonGroup();
		
		autoDiapo = new JRadioButton("Auto");
		autoDiapo.setSelected(true);
		affichDiapo = new JRadioButton("Afficher");
		cachDiapo = new JRadioButton("Cacher");
		
		autoDiapo.setActionCommand("Auto");
		affichDiapo.setActionCommand("Afficher");
		cachDiapo.setActionCommand("Cacher");
		
		groupDiapo.add(autoDiapo);
		groupDiapo.add(affichDiapo);
		groupDiapo.add(cachDiapo);
		
		diapoP.add(diapoL);
		diapoP.add(autoDiapo);
		diapoP.add(affichDiapo);
		diapoP.add(cachDiapo);
		
		JPanel boutonP = new JPanel();
		JLabel boutonL = new JLabel("Diaporama");
		ButtonGroup groupBouton = new ButtonGroup();
		
		autoBouton = new JRadioButton("Auto");
		autoBouton.setSelected(true);
		affichBouton = new JRadioButton("Afficher");
		cachBouton = new JRadioButton("Cacher");
		
		autoBouton.setActionCommand("Auto");
		affichBouton.setActionCommand("Afficher");
		cachBouton.setActionCommand("Cacher");
		
		groupBouton.add(autoBouton);
		groupBouton.add(affichBouton);
		groupBouton.add(cachBouton);
		
		boutonP.add(boutonL);
		boutonP.add(autoBouton);
		boutonP.add(affichBouton);
		boutonP.add(cachBouton);
		
		cont.add(panel);
		cont.add(textP);
		cont.add(diapoP);
		cont.add(boutonP);
		
		boutonsAff();
		
		JPanel boutonsPanel = new JPanel();
		JButton valider = new JButton("Valider");
		valider.addActionListener(new ActionValider(groupConv, groupText, groupDiapo, groupBouton, a, this));
		JButton quitter = new JButton("Quitter");
		quitter.addActionListener(new ActionQuitter(this));
		
		boutonsPanel.add(valider);
		boutonsPanel.add(quitter);
		add(boutonsPanel, BorderLayout.SOUTH);
	}
	
	public void boutonsAff() {
		try (InputStream input = new FileInputStream("src/main/java/edu/mermet/tp8/configuration/bouton.properties")) {
			
    		Properties p = System.getProperties();
        	String name = p.getProperty("user.name");
    		
			Properties prop = new Properties();

            prop.load(input);
            
            if(prop.getProperty("conv"+name).contains("Auto")) {
            	autoConv.setSelected(true);
            }else if (prop.getProperty("conv"+name).contains("Afficher")) {
            	affichConv.setSelected(true);
            }else {
            	cachConv.setSelected(true);
            }
            
		}catch (IOException ex) {
            ex.printStackTrace();
        }
	}
}
