package edu.mermet.tp8.boite;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeSelectionModel;

import edu.mermet.tp8.Application;
import edu.mermet.tp8.actions.GestionSelection;
import edu.mermet.tp8.ecouteur.EcouteurCommentFaire;

public class BoiteCommentFaire extends JDialog {
	private JTree tree;
	private TreeModel arbre;
	
	public BoiteCommentFaire(Application f) {
		super(f, "Aide");
		init();
		this.setSize(400, 300);
		this.setDefaultCloseOperation(HIDE_ON_CLOSE);
		this.addWindowListener(new EcouteurCommentFaire(f.getActionCommentFaire()));
	}
	
	public void init() {
		tree = new JTree();
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout()); 
	    setContentPane(panel);
		panel.add(tree, BorderLayout.WEST);
		
		try (InputStream input = new FileInputStream("src/main/java/edu/mermet/tp8/HowTo/titres.properties")) {

            Properties prop = new Properties();

            prop.load(input);
            
            DefaultMutableTreeNode racine = new DefaultMutableTreeNode(prop.getProperty("racine"));
    		arbre = new DefaultTreeModel(racine);
    		DefaultMutableTreeNode noeudCourant, ancetre;
    		ancetre = racine;
    		noeudCourant = new DefaultMutableTreeNode(prop.getProperty("conversion"));
    		ancetre.add(noeudCourant);
    		ancetre = noeudCourant;
    		noeudCourant = new DefaultMutableTreeNode(prop.getProperty("CelFar"));
    		ancetre.add(noeudCourant);
    		noeudCourant = new DefaultMutableTreeNode(prop.getProperty("FarCel"));
    		ancetre.add(noeudCourant);
    		ancetre = racine;
    		noeudCourant = new DefaultMutableTreeNode(prop.getProperty("gras"));
    		ancetre.add(noeudCourant);
    		noeudCourant = new DefaultMutableTreeNode(prop.getProperty("couleur"));
    		ancetre.add(noeudCourant);
    		tree.setModel(arbre);

        } catch (IOException ex) {
            ex.printStackTrace();
        }		
		
		JPanel panel2 = new JPanel();
		panel2.setLayout(new FlowLayout(FlowLayout.LEFT));
		JEditorPane html = new JEditorPane();
		panel2.add(html, BorderLayout.WEST);
		add(panel2, BorderLayout.CENTER);
		TreeSelectionModel modeleSelection = new DefaultTreeSelectionModel();
		 modeleSelection.setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
		 tree.setSelectionModel(modeleSelection); 
		 tree.addTreeSelectionListener(new GestionSelection(html));
	}
}
