package edu.mermet.tp8.actions;

import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;

import edu.mermet.tp8.Application;
import edu.mermet.tp8.ecouteur.EcouteurConversion;

public class ActionAfficherConversion extends AbstractAction {
	public Application a;
	
    public ActionAfficherConversion(Application a) {
        super("Conversion Celsius/Farenheit");
        this.a = a;
        putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_C, InputEvent.CTRL_DOWN_MASK));
        putValue(Action.MNEMONIC_KEY,KeyEvent.VK_C);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
    	
    	try (InputStream input = new FileInputStream("src/main/java/edu/mermet/tp8/configuration/bouton.properties")) {
			
    		Properties p = System.getProperties();
        	String name = p.getProperty("user.name");
    		
			Properties prop = new Properties();

            prop.load(input);
            
            if(prop.getProperty("conv"+name).contains("Auto")) {
            	a.getFenetreConversions().setVisible(true);
            	a.getFenetreConversions().addInternalFrameListener(null);
                a.enableConversion(false);
            }else if (prop.getProperty("conv"+name).contains("Afficher")) {
            	a.getFenetreConversions().setVisible(true);
            	a.getFenetreConversions().addInternalFrameListener(new EcouteurConversion(a.getFenetreConversions(), this));
            	//a.getActionAfficherConversion().actionPerformed(ae);
                a.enableConversion(false);
            }else {
            	a.getFenetreConversions().setVisible(false);
            	a.getFenetreConversions().addInternalFrameListener(null);
                a.enableConversion(false);
            }
            
		}catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}
