package edu.mermet.tp8.fenetres;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Properties;

public class Preferences {
    private static String localFolder = File.separator + ".ihm" + File.separator;
    private static String fileName = "properties.xml";
    private static String filePath;
    private final Properties properties;
    private static Preferences instance;

    private Preferences() {
        filePath = System.getProperty("user.home") + localFolder;
        properties = new Properties();
    }

    public static Preferences getInstance() {
        if (instance == null) instance = new Preferences();

        try {
            if (!Files.isDirectory(Paths.get(filePath))) {
                Files.createDirectory(Paths.get(filePath));
            }
            if (!Files.exists(Paths.get(filePath + fileName))){
                instance.properties.setProperty("conversion", "Auto");
                instance.properties.setProperty("saisie"    , "Auto");
                instance.properties.setProperty("diapo"     , "Auto");
                instance.properties.setProperty("boutons"   , "Auto");
                instance.properties.setProperty("suggestion", "true");

                instance.sauvegarder();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return instance;
    }

    public void sauvegarder() {
        try {
            FileOutputStream fos = new FileOutputStream(filePath + fileName);
            properties.storeToXML(fos, null);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void charger() {
        try {
            FileInputStream fis = new FileInputStream(filePath + fileName);
            properties.loadFromXML(fis);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void ajouter(String key, String val) {
        properties.setProperty(key, val);
    }

    public String lire(String key) {
        return properties.getProperty(key);
    }
}
