package edu.mermet.tp8.fenetres;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;

public class FenetreSuggestion extends JDialog {
    private JLabel message;
    private JButton fermer, stopAfficher;
    private String msg;

    public FenetreSuggestion() {
        setTitle("Suggestion du jour");
        init();
        pack();
        setModal(false);
        setVisible(true);
        setLocationRelativeTo(null);
    }

    private void init() {
        setLayout(new BorderLayout());
        msg = getMessageAleatoire();
        message = new JLabel("<html><div style='text-align: center;'>" + msg + "</div></html>");
        add(message, BorderLayout.CENTER);

        fermer = new JButton("Fermer");
        fermer.addActionListener(new ActionFermer());

        stopAfficher = new JButton("Ne plus afficher");
        stopAfficher.addActionListener(new ActionStopAfficher());

        JPanel pBtn = new JPanel(new FlowLayout(FlowLayout.CENTER));
        pBtn.add(fermer);
        pBtn.add(stopAfficher);

        add(pBtn, BorderLayout.SOUTH);
    }

    private String getMessageAleatoire() {
        String ret = "Une erreur est survenue dans la génération du message.";
        try {
            Properties propSugg = new Properties();
            InputStream inputSugg = getClass().getClassLoader().getResourceAsStream("suggestions.properties");
            propSugg.load(inputSugg);

            int n = (int) (Math.random() * propSugg.size()) + 1;
            ret = propSugg.getProperty("s" + n);
        } catch (IOException e) {
            e.printStackTrace();
        }

        return ret;
    }

    private class ActionFermer implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            dispose();
        }
    }

    private class ActionStopAfficher implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            Preferences prefs = Preferences.getInstance();
            prefs.charger();
            prefs.ajouter("suggestion", "false");
            prefs.sauvegarder();
            dispose();
        }
    }
}
