package edu.mermet.tp8.fenetres;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Objects;
import javax.swing.*;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import edu.mermet.tp8.Application;

/**
 *
 * @author brunomermet
 */
public class FenetreConversion extends AbstractFenetreInterne {
    private JTextField champCelsius;
    private JTextField champFarenheit;
    private JButton boutonConvertir;
    private Action actionConvertir;
    private boolean celsiusAFocus;
    public FenetreConversion(Action action) {
        super(action,"Conversion celsius/Farenheit");
        this.setSize(new Dimension(100,50));
        this.setLayout(new GridLayout(3,1));
        JPanel ligneCelsius = new JPanel();

        String txtAideFare = "Entrez une température en degrés Farenheit";
        String txtAideCels = "Entrez une température en degrés Celsius";

        ligneCelsius.setLayout(new FlowLayout(FlowLayout.TRAILING));
        ligneCelsius.setToolTipText(txtAideCels);
        JLabel labCelsius = new JLabel("Celsius :");
        champCelsius = new JTextField(15);
        labCelsius.setLabelFor(champCelsius);
        ligneCelsius.add(labCelsius);
        ligneCelsius.add(champCelsius);

        // ------ Bouton d'aide contextuelle ------
        ImageIcon icon = new ImageIcon(Objects.requireNonNull(getClass().getClassLoader().getResource("questionmarkicon.png")));
        Icon resized = new ImageIcon(icon.getImage().getScaledInstance(15,15, Image.SCALE_SMOOTH));
        JButton aideCels = new JButton(resized);
        aideCels.setSize(15, 15);
        aideCels.addActionListener(new ActionAideConversion(txtAideCels, this));
        ligneCelsius.add(aideCels);

        this.add(ligneCelsius);
        celsiusAFocus = true;
        champCelsius.addFocusListener(new EcouteurFocus(true));


        JPanel ligneFarenheit = new JPanel();
        ligneFarenheit.setToolTipText(txtAideFare);
        ligneFarenheit.setLayout(new FlowLayout(FlowLayout.TRAILING));
        JLabel labFarenheit = new JLabel("Farenheit :");
        champFarenheit = new JTextField(15);
        labFarenheit.setLabelFor(champFarenheit);
        ligneFarenheit.add(labFarenheit);
        ligneFarenheit.add(champFarenheit);

        // ------ Bouton d'aide contextuelle ------
        JButton aideFare = new JButton(resized);
        aideFare.addActionListener(new ActionAideConversion(txtAideFare, this));
        aideFare.setSize(15, 15);
        ligneFarenheit.add(aideFare);

        this.add(ligneFarenheit);
        champFarenheit.addFocusListener(new EcouteurFocus(false));


        JPanel ligneValider = new JPanel();
        ligneValider.setLayout(new FlowLayout(FlowLayout.CENTER));
        actionConvertir = new ActionConvertir();
        boutonConvertir = new JButton(actionConvertir);
        ligneValider.add(boutonConvertir);
        this.add(ligneValider);
        
        pack();
        getRootPane().setDefaultButton(boutonConvertir);
    }

    private class EcouteurFocus implements FocusListener {
        private boolean aStocker;

        public EcouteurFocus(boolean b) {
            aStocker = b;
        }

        @Override
        public void focusGained(FocusEvent fe) {
            celsiusAFocus = aStocker;
        }

        @Override
        public void focusLost(FocusEvent fe) {
            return;
        }
    }

    private class ActionConvertir extends AbstractAction {

        public ActionConvertir() {
            super("Convertir");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            double tempCelsius = 0;
            double tempFarenheit = 0;
            if (celsiusAFocus) {
                try {
                    tempCelsius = Double.parseDouble(champCelsius.getText());
                tempFarenheit = 9./5*tempCelsius+32;
                champFarenheit.setText(""+tempFarenheit);
                }
                catch (NumberFormatException nfe) {
                    champFarenheit.setText("Format incorrect");
                }
                }
            else {
                try {
                    tempFarenheit = Double.parseDouble(champFarenheit.getText());
                    tempCelsius = (tempFarenheit - 32) *5./9;
                    champCelsius.setText(""+tempCelsius);
                }
                catch (NumberFormatException nfe) {
                    champCelsius.setText("Format incorrect");
                }
                
            }
        }
    }

    private class ActionAideConversion implements ActionListener {
        String texte;
        FenetreConversion fc;

        public ActionAideConversion(String txt, FenetreConversion parent) {
            texte = txt;
            fc = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(fc, texte, "Aide à la conversion", JOptionPane.INFORMATION_MESSAGE);
        }
    }
}
