package edu.mermet.tp8.fenetres;

import javax.swing.*;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.stream.Collectors;

public class DialogHowTo extends JDialog {
    private JSplitPane splitPane;
    private JList listHowTo;
    private JEditorPane htmlPane;

    private HashMap<String, String> data;

    private static final String propFicTitre = "HowTo/titres.properties";
    private static final String propFicTexte = "HowTo/textes.properties";

    public DialogHowTo() {
        setTitle("Comment faire ?");
        init();
        pack();
        setModal(false);
        setVisible(true);
        setLocationRelativeTo(null);
    }

    private void init() {
        loadData();
        listHowTo = new JList<>(data.keySet().stream().sorted().toArray());
        htmlPane = new JEditorPane();
        htmlPane.setEditorKit(new HTMLEditorKit());

        listHowTo.addListSelectionListener(new SelectionListenerListeTitres());

        listHowTo.setLayout(new GridLayout(10, 1));
        listHowTo.setPreferredSize(new Dimension(100, 200));
        listHowTo.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

        htmlPane.setPreferredSize(new Dimension(300,200));

        splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, listHowTo, htmlPane);
        add(splitPane);
    }

    private void loadData() {
        data = new HashMap<>();
        try {
            Properties propTitres = new Properties();
            InputStream inputTitres = getClass().getClassLoader().getResourceAsStream(propFicTitre);
            propTitres.load(inputTitres);

            Properties propTextes = new Properties();
            InputStream inputTextes = getClass().getClassLoader().getResourceAsStream(propFicTexte);
            propTextes.load(inputTextes);

            for(String propName : propTitres.stringPropertyNames()) {
                String cle = propTitres.getProperty(propName);
                String val = propTextes.getProperty(propName) == null ? "" : propTextes.getProperty(propName);
                data.put(cle, val);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class SelectionListenerListeTitres implements ListSelectionListener {

        @Override
        public void valueChanged(ListSelectionEvent e) {
            String choix = (String) listHowTo.getSelectedValue();
            htmlPane.setText(data.get(choix));

            if (choix.equals("Quitter")) {
                dispose();
            }
        }
    }
}
