package edu.mermet.tp8.fenetres;

import edu.mermet.tp8.Application;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;

public class DialogConfiguration extends JDialog {
    private static final String[] libs  = {"Conversion Celsius/Fahrenheit", "Saisie de texte", "Diaporama", "Boutons"};
    private static final String[] props = {"conversion", "saisie", "diapo", "boutons"};
    private static final String[] options = {"Auto", "Affiché", "Caché"};

    private JButton valider, annuler;
    private ButtonGroup[] grps;

    private Application app;

    private Preferences prefs;

    public DialogConfiguration(Application appli) {
        app = appli;
        setTitle("Configuration des menus");
        init();
        pack();
        setModal(false);
        setVisible(true);
        setLocationRelativeTo(null);
    }

    private void init() {
        prefs = Preferences.getInstance();
        prefs.charger();

        setLayout(new GridLayout(5,1));

        grps = new ButtonGroup[4];

        for (int i = 0; i < 4; i++) {

            add(new JLabel(libs[i]));
            grps[i] = new ButtonGroup();
            JPanel ligne = new JPanel(new FlowLayout(FlowLayout.TRAILING));

            for (int j = 0; j < 3; j++) {
                boolean isSelected = options[j].equals(prefs.lire(props[i]));
                JRadioButton btn = new JRadioButton(options[j], isSelected);
                grps[i].add(btn);
                ligne.add(btn);
            }
            add(ligne);
        }

        JPanel ligneBtn = new JPanel(new FlowLayout(FlowLayout.CENTER));
        valider = new JButton("Valider");
        valider.addActionListener(new ValiderAction());
        ligneBtn.add(valider);
        annuler = new JButton("Annuler");
        annuler.addActionListener(new AnnulerAction());
        ligneBtn.add(annuler);
        add(ligneBtn);
    }

    public class ValiderAction implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            Preferences prefs = Preferences.getInstance();
            for (int i = 0; i < grps.length; i++) {
                for (Enumeration<AbstractButton> btns = grps[i].getElements(); btns.hasMoreElements();) {
                    AbstractButton btn = btns.nextElement();

                    if (btn.isSelected()) {
                        prefs.ajouter(props[i], btn.getText());
                        app.majVisuItemMenu(i, !btn.getText().equals("Caché"));
                    }
                }
            }

            prefs.sauvegarder();

            dispose();
        }
    }

    public class AnnulerAction implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            dispose();
        }
    }
}
