import React, {useState, useEffect} from 'react';
import {Button, Stack} from "react-bootstrap";
import 'bootstrap/dist/css/bootstrap.min.css';
import './App.css';

function App() {
    const [enregistre, setEnregistre] = useState(false);
    const [text,setText] = useState("Les données ne sont pas enregistrées");

    // Équivalent à componentDidMount plus componentDidUpdate :
    useEffect(() => {
        if (enregistre) {
            setText("Enregistrement en cours")
        } else {
            setText("Les données ne sont pas enregistrées")
        }
        console.log(enregistre);
    });

    return (
        <>
        <head>
            <title>controlleur capteur</title>
            <script src="https://unpkg.com/react/umd/react.production.min.js" crossOrigin/>
        </head>
        <div>
            <h1>Lancer l'enregistrement des données des capteurs</h1>

            <Stack gap={2} className="col-md-5 mx-auto">
                <p>{text}</p>
                <Button
                    variant="outline-primary"
                    onClick={() => setEnregistre(!enregistre)}
                >enregistrement
                </Button>{' '}
            </Stack>
        </div>
        </>
    );
}

export default App;