from django.db import models
import tablib

# Create your models here.

class Ville(models.Model):
    """
    La Table Ville contient :
    le nom de la ville ainsi qu'un identifiant pour servir de clef primaire.

    """
    ville_nom = models.CharField(max_length=100, unique=True)
    ville = models.IntegerField(primary_key=True)

class Rassemblement_ville(models.Model):
    """
    La table Rassemblement_ville contient deux clefs étrangères :
    - ville_englobante l'identifiant de clef étrangère venant de la table Ville représentant la ville composé de
    plusieurs villes
    - ville, composante de la ville ville_englobante

    il y a comme contraintes :
    - l'ensemble (ville_englobante, ville) doit être unique
    - une ville ne peut pas s'englober elle même
    """
    ville_englobante = models.ForeignKey(Ville, on_delete=models.CASCADE, related_name="id_ville_englobante",
       db_column='un_id', related_query_name="%(app_label)s_%(class)ss")
    ville = models.ForeignKey(Ville, on_delete=models.CASCADE,  related_name="ville_id_rassemblement",
        db_column='autre_id', related_query_name="%(app_label)s_%(class)ss")




    class Meta:
        unique_together = ('ville_englobante', 'ville')
        constraints = [
            models.CheckConstraint(check=~models.Q(ville_englobante=models.F('ville')), name='ville_englobante_ne_peut-senglober'),
        ]


class Graph_viaire_ville_information(models.Model):
    """
    La table Graph_viaire_ville_information est la table remplit de toutes les informations qu'il est possible d'avoir
    sur un graph.

    La classe possède en mémoire le nom des formats d'exports possible.

    """
    gvvi_cout = models.FloatField()
    gvvi_robustesse = models.FloatField()
    gvvi_d2_correlation_dimension = models.FloatField()
    gvvi_d1_information_dimension = models.FloatField()
    gvvi_d0_fractal_capacite_dimension = models.FloatField()
    gvvi_longueur_moyenne_rues = models.FloatField()
    gvvi_tree_vs_complete_graph = models.FloatField()
    gvvi_org_plan_vs_organized = models.FloatField()
    gvvi_connectivity = models.FloatField()
    gvvi_degre_moyen = models.FloatField()
    gvvi_diametre = models.IntegerField()
    gvvi_nb_intersection = models.IntegerField()
    ville = models.OneToOneField(Ville, on_delete=models.CASCADE)

    formats_exports = []
    for func in dir(tablib.Dataset()):
        if func.startswith("get_") and not (func.endswith("col") or func.endswith("dbf")):
            formats_exports.append((len(formats_exports), func))

    def __str__(self):
        """
        Cette méthode permet d'afficher les données importantes de la classe

        :return:
        """
        return self.ville.ville_nom + " : " + self.gvvi_nb_intersection.__str__()

