from django.contrib import admin

# Register your models here.
from import_export import fields, resources
from import_export.widgets import ForeignKeyWidget
from import_export import formats
from import_export import widgets
from recuperateur_reseau_viaire.models import Graph_viaire_ville_information, Ville, Rassemblement_ville



class Graph_viaire_ville_informationResource(resources.ModelResource):

    ville = fields.Field(
        column_name='ville',
        attribute='ville',
        widget=ForeignKeyWidget(Ville, 'ville_nom')
    )
    class Meta:
        model = Graph_viaire_ville_information
        sgbd_var = [var for var in dir(model) if var.startswith("gvvi_") and var != 'gvvi_nom']
        export_order = ('id', 'ville')
        for var in sgbd_var:
            export_order = export_order + (var, )

admin.site.register(Graph_viaire_ville_information)
admin.site.register(Ville)
admin.site.register(Rassemblement_ville)
