from django.test import TestCase
from recuperateur_reseau_viaire.forms import Graph_viaire_ville_informationForm_export
from recuperateur_reseau_viaire.models import Graph_viaire_ville_information, Ville, Rassemblement_ville
from django.http import QueryDict

class test_form_export_SGBDTestCase(TestCase):

    def setUp(self) -> None:
        """
        Créé une ligne dans la base de donnée Graph_viaire_ville_information au départ pour chaque test
        """
        self.nom_ville_test = "super commune"
        #création d'une instance de Ville
        Ville.objects.create(ville_nom=self.nom_ville_test)
        Ville.objects.create(ville_nom="commune A")
        Ville.objects.create(ville_nom="commune B")

        Rassemblement_ville.objects.create(ville_englobante=Ville.objects.get(ville_nom=self.nom_ville_test),
                                           ville=Ville.objects.get(ville_nom="commune A"))
        Rassemblement_ville.objects.create(ville_englobante=Ville.objects.get(ville_nom=self.nom_ville_test),
                                           ville=Ville.objects.get(ville_nom="commune B"))
        Graph_viaire_ville_information.objects.create(gvvi_cout = 0, gvvi_robustesse = 0,
                    gvvi_d2_correlation_dimension = 0, gvvi_d1_information_dimension = 0, gvvi_d0_fractal_capacite_dimension = 0,
                gvvi_longueur_moyenne_rues = 0, gvvi_tree_vs_complete_graph = 0, gvvi_org_plan_vs_organized = 0, gvvi_connectivity = 0,
    gvvi_degre_moyen = 0, gvvi_diametre = 0,gvvi_nb_intersection = 0,ville = Ville.objects.get(ville_nom=self.nom_ville_test))

    def test_creation_form_vide_suppression(self):
        """
        Ce teste créé un formulaire de suppression de Graph_viaire_ville_information sans modification
         et doit être valide.
        """
        form = Graph_viaire_ville_informationForm_export()
        self.assertFalse(form.is_valid())

    def test_creation_form_suppression_basic(self):
        """
        Ce teste créé un formulaire de suppression de Graph_viaire_ville_information sans modification
         et doit être valide.
        """
        entree_form = QueryDict("choix_format_export=0")
        form = Graph_viaire_ville_informationForm_export(entree_form)
        self.assertTrue(form.is_valid())
