from django.contrib.staticfiles.testing import StaticLiveServerTestCase

from selenium.webdriver.common.by import By
from selenium.webdriver.firefox.webdriver import WebDriver


class test_view_telecharge_list_communeTests(StaticLiveServerTestCase):
    selenium = None

    @classmethod
    def setUpClass(cls):
        """
        Le but de cette méthode est d'initialiser selenium avant le début des tests de la classe

        """
        super().setUpClass()
        cls.selenium = WebDriver()
        cls.selenium.implicitly_wait(10)

    @classmethod
    def tearDownClass(cls):
        """
        Le but de cette méthode est de fermer selenium à la fin des tests de la classe
        """
        cls.selenium.quit()
        super().tearDownClass()

    def setUp(self) -> None:
        """
        Le but de cette méthode est que selenium soit dans l'index du site à chaque test
        """
        self.selenium.get('%s%s' % (self.live_server_url, '/recuperateur_reseau_viaire/telecharge_liste_commune'))

    def test_bouton_ajouter_ville(self):
        """
        Le but de cette méthode est de tester le bouton ajouter ville du formulaire en testant avant appuie et après
        """
        # test valeur label avant appuie sur le bouton ajouter ville
        #récupére la liste de label dans le tableau
        labels_liste = self.selenium.find_element(By.CSS_SELECTOR, "#form").find_element(By.CSS_SELECTOR, "tbody") \
            .find_elements(By.XPATH, '//label[@for="id_gvvi_nom"]')
        self.assertEqual(len(labels_liste), 1)
        self.assertEqual(labels_liste[0].text, "nom de la ville :")
        #ajoute une entrée de ville en appuyant sur le bouton
        self.selenium.find_element(By.CLASS_NAME, "ajoute_liste_ligne").click()
        # ajoute une entrée de ville en appuyant sur le bouton
        self.selenium.find_element(By.CLASS_NAME, "ajoute_liste_ligne").click()
        #récupére la liste de label dans le tableau
        labels_liste = self.selenium.find_element(By.CSS_SELECTOR, "#form").find_element(By.CSS_SELECTOR, "tbody")\
            .find_elements(By.XPATH, '//label[@for="id_gvvi_nom"]')
        for id_label in range(len(labels_liste)):
            # le texte de première ligne a changé
            if id_label != 0 or len(labels_liste) == 1:
                self.assertEqual(labels_liste[id_label].text, "nom de la ville :")
            else :
                self.assertEqual(labels_liste[id_label].text, "Nom de l'ensemble des communes :")

    def test_bouton_supprimer_ville(self):
        """
        Cette méthode a pour but de supprimmer une ligne de ville après avoir appuyé dessus
        """
        # ajoute une entrée de ville en appuyant sur le bouton
        self.selenium.find_element(By.CLASS_NAME, "ajoute_liste_ligne").click()
        self.selenium.find_element(By.CLASS_NAME, "suppr_liste_ligne").click()
        labels_liste = self.selenium.find_element(By.CSS_SELECTOR, "#form").find_element(By.CSS_SELECTOR, "tbody") \
            .find_elements(By.XPATH, '//label[@for="id_gvvi_nom"]')
        self.assertEqual(len(labels_liste), 1)
        self.assertEqual(labels_liste[0].text, "nom de la ville :")

