from django.shortcuts import render
from recuperateur_reseau_viaire.forms import Graph_viaire_ville_informationForm
from recuperateur_reseau_viaire.models import Graph_viaire_ville_information, Ville, Rassemblement_ville
from .view_valide import valide


def telecharge_liste_commune(request):
    """
    Cette méthode a pour but de créer un formulaire de création de communes. Les communes peuvent être soit téléchargé
    seule, soit en en groupe.

    Elle reçoit une requête de récupération GET pour la création du formulaire et une requête de modification de la base
    de donnée POST à la fin de la validation du formulaire.

    :param request:
    :return: une HttpResponse de la page telecharge_liste_commune.html pour la création du formulaire et sa validation
    et valide.html en cas de validation du formulaire à l'aide de django.template.loader.render_to_string().
    """
    if request.method == "GET":
        #création du formulaire de vide
        form = Graph_viaire_ville_informationForm()
        return render(request, 'recuperateur_reseau_viaire/telecharge_liste_commune.html',
                      {'form': form})
    else:
        form = Graph_viaire_ville_informationForm(request.POST)
        if form.is_valid():
            action_telechargement_formulaire_valide(form.cleaned_data, request.POST.getlist("gvvi_nom_ajout"))
            return valide(request)
        else:
            nom_villes = request.POST.getlist("gvvi_nom_ajout")
            return render(request, 'recuperateur_reseau_viaire/telecharge_liste_commune.html',
                      {'form': form, 'nom_villes_ajout' : nom_villes})


def action_telechargement_formulaire_valide(form_cleaned_data, liste_gvvi_nom_ajout):
    """
    Cette méthode a pour but de faire les actions du formulaire de téléchargement de ville, une fois qu'il est valide.

    Les actions effectuées ici sont :
    - création des instances de Villes provenant :
        - de la nouvelle ville
        - des composantes de la nouvelle ville si ceux-ci n'éxistent pas déjà
    - création des instances de Rassemblement_ville si la ville est composée de villes
    - création de la nouvelle ligne graph_viaire_ville_information

    :param form: le formulaire et ses informations
    :param liste_gvvi_nom_ajout : la liste de nom de villes qui composent la nouvelle ville
    :return:
    """
    # récupération des villes déjà existantes
    nom_villes = liste_gvvi_nom_ajout.copy()
    nom_villes.append(form_cleaned_data["gvvi_nom"])
    ville_instance_liste = Ville.objects.filter(ville_nom__in=nom_villes)
    # création de l'instance ville si elle n'existe pas déjà et récupération
    if not ville_instance_liste.filter(ville_nom=form_cleaned_data["gvvi_nom"]).exists():
        Ville.objects.create(ville_nom=form_cleaned_data["gvvi_nom"])
        ville_ajoutee = Ville.objects.filter(ville_nom=form_cleaned_data["gvvi_nom"])[0]
    else:
        ville_ajoutee = ville_instance_liste.filter(ville_nom=form_cleaned_data["gvvi_nom"])[0]

    # création de l'instance graph_viaire_ville_information
    form_cleaned_data.pop("gvvi_nom")
    graph_viaire_ville_information_instance = Graph_viaire_ville_information()
    graph_viaire_ville_information_instance.ville_id = ville_ajoutee.ville
    for clef in form_cleaned_data.keys():
        graph_viaire_ville_information_instance.__setattr__(clef, form_cleaned_data[clef])
    graph_viaire_ville_information_instance.save()
    # création des villes lorsqu'ils n'existent pas déjà
    for nom_ville_englobe in liste_gvvi_nom_ajout:
        try:
            ville_instance = Ville()
            ville_instance.ville_nom = nom_ville_englobe
            ville_instance.save()
        except Exception:
            pass
    # ajout dans la table rassemblement_ville des villes faisant parties d'une ville
    ville_instance_englobe_liste = ville_instance_liste.filter(ville_nom__in=liste_gvvi_nom_ajout)
    for ville_englobe in ville_instance_englobe_liste:
        #rassemblement_ville_instance = Rassemblement_ville.objects.create(ville_englobante_id=ville_ajoutee.ville, ville_id=ville_englobe.ville)
        rassemblement_ville_instance = Rassemblement_ville()
        rassemblement_ville_instance.ville_englobante_id = ville_ajoutee.ville
        rassemblement_ville_instance.ville_id = ville_englobe.ville
        rassemblement_ville_instance.save()
