from django.conf import settings
from django.shortcuts import render
from recuperateur_reseau_viaire.admin import Graph_viaire_ville_informationResource
from recuperateur_reseau_viaire.forms import Graph_viaire_ville_informationForm_export
from recuperateur_reseau_viaire.models import Graph_viaire_ville_information
from .view_valide import valide

def export(request):
    """
    Cette méthode permet de créer un formulaire d'exportation de la base de donnée au format choisi disponible.

    :param request:
    :return:
    """
    if request.method == 'POST':
        # gestion formulaire soumis
        form_e = Graph_viaire_ville_informationForm_export(request.POST,
                                                           initial={'formats_exports': format})
        if form_e.is_valid():
            action_exportation_formulaire_valide(form_e.cleaned_data['choix_format_export'])
            return valide(request)
    else:
        # création du formulaire préremplit de la proposition par défaut
        form_e = Graph_viaire_ville_informationForm_export()
        return render(request, 'recuperateur_reseau_viaire/export.html', {'form_e': form_e})


def action_exportation_formulaire_valide(format_export):
    """
    Cette méthode a pour but d'exporter au format sous forme de fichier la base de donnée au format choisis.
    Elle crée le fichier d'exportation au nom "export_sgbd.[format_choisi]" dans le dossier Data

    :param format_export : format de fichier d'exportation choisi par l'utilisateur
    """
    sgbd_donnees = getattr(Graph_viaire_ville_informationResource().export(),
                           Graph_viaire_ville_information.formats_exports[
                               int(format_export)][1])()
    fichier = open(settings.REGISTER_DIR + "/export_sgbd." + Graph_viaire_ville_information.formats_exports[
        int(format_export)][1].removeprefix("get_"), "w")
    fichier.write(sgbd_donnees)
    fichier.close()