from OSM_outils.OMSnx_enregistrement import OMSnx_enregistrement
from OSM_outils.OSMnx_recuperation_graph_information import OSMnx_recuperation_graph_information
from django import forms
from django.core.exceptions import ValidationError
from recuperateur_reseau_viaire.models import Graph_viaire_ville_information, Ville



class Graph_viaire_ville_informationFormUpdate(forms.Form):
    """
    Cette méthode permet de modifier une nouvelle donnée dans la table Graph_viaire_ville_information

    """
    from_python = {"int": forms.IntegerField, "float": forms.FloatField, "bool": forms.BooleanField}

    def __init__(self, *args, **kwargs):
        super(Graph_viaire_ville_informationFormUpdate, self).__init__(*args, **kwargs)
        initial_arguments = kwargs.get('initial', None)
        if initial_arguments:
            graph_viaire_ville_information = initial_arguments.get('valeur', None)
            liste = False
            if isinstance(graph_viaire_ville_information, list):
                graph_viaire_ville_information = graph_viaire_ville_information[0]
                liste = True
            #on associe à chaque variable un nom de fonction de OSMnx_recuperation_graph_information
            tableau_associatif_nom_variable_nom_fonction = {}
            var_OSMnx_recuperation_graph_information = OSMnx_recuperation_graph_information(None)
            liste_fonction_recup_graph_information = var_OSMnx_recuperation_graph_information.sgbd_liste_fonction()
            for func in liste_fonction_recup_graph_information:
                retour = getattr(var_OSMnx_recuperation_graph_information, func)(None)
                nom_variable_sgbd = next(iter(retour))
                tableau_associatif_nom_variable_nom_fonction[nom_variable_sgbd] = \
                    {"nom_fonction" : func,
                    "type_retour" : type(getattr(graph_viaire_ville_information, nom_variable_sgbd)).__name__}
            if not liste:
                self.fields['gvvi_nom'] = forms.CharField(required=True, initial=graph_viaire_ville_information.ville.ville_nom,
                                                      label="nom de la ville ")
            for champ in dir(graph_viaire_ville_information):
                if champ.startswith("gvvi_") and tableau_associatif_nom_variable_nom_fonction.get(champ) is not None:
                    if not liste:
                        self.fields[champ] = self.from_python[tableau_associatif_nom_variable_nom_fonction[champ]["type_retour"]](required=True,
                                        initial=getattr(graph_viaire_ville_information, champ))
                    else:
                        self.fields[champ] = self.from_python[
                            tableau_associatif_nom_variable_nom_fonction[champ]["type_retour"]](required=False)
                    self.fields[champ + "_check"] = forms.BooleanField(required=False, label="modification fonction")

    def clean_gvvi_nom(self):
        print("changed : ", self.changed_data)
        if "gvvi_nom" in self.changed_data:
            if Ville.objects.filter(ville_nom=self.cleaned_data["gvvi_nom"]).exists():
                raise ValidationError('ville %(gvvi_nom)s déjà enregistrée dans la base de donnée',
                                      params={'gvvi_nom': self.cleaned_data["gvvi_nom"]})
            try:
                OMSnx_enregistrement.renommer_fichier_graphml(None, self.cleaned_data["gvvi_nom"])
            except ValueError:
                raise ValidationError({"gvvi_nom" : 'le fichier %(gvvi_nom)s existe déjà dans le dossier Data'},
                                      code='invalide', params={'gvvi_nom': self.cleaned_data["gvvi_nom"]})
        return self.cleaned_data["gvvi_nom"]