from django.shortcuts import render
from recuperateur_reseau_viaire.forms import Graph_viaire_ville_informationForm
from recuperateur_reseau_viaire.models import Graph_viaire_ville_information, Ville, Rassemblement_ville
from .view_valide import valide


def telecharge_liste_commune(request):
    """
    Cette méthode a pour but de créer un formulaire de création de communes. Les communes peuvent être soit téléchargé
    seule, soit en en groupe.

    Elle reçoit une requête de récupération GET pour la création du formulaire et une requête de modification de la base
    de donnée POST à la fin de la validation du formulaire.

    :param request:
    :return: une HttpResponse de la page telecharge_liste_commune.html pour la création du formulaire et sa validation
    et valide.html en cas de validation du formulaire à l'aide de django.template.loader.render_to_string().
    """
    if request.method == "GET":
        form = Graph_viaire_ville_informationForm()
        return render(request, 'recuperateur_reseau_viaire/telecharge_liste_commune.html',
                      {'form': form})
    else:
        form = Graph_viaire_ville_informationForm(request.POST)
        #récupération unique des nom des villes impliqué dans la création
        nom_villes = request.POST.getlist("gvvi_nom_ajout")
        nom_villes.append(request.POST.getlist("gvvi_nom")[0])
        ville_instance_liste = Ville.objects.filter(ville_nom__in=nom_villes)
        if form.is_valid():
            graph_viaire_ville_information_instance = Graph_viaire_ville_information()
            #création de la nouvelle ville si elle n'existe pas
            if not ville_instance_liste.filter(ville_nom=request.POST.getlist("gvvi_nom")[0]).exists():
                Ville.objects.create(ville_nom=form.cleaned_data["gvvi_nom"])
            ville_ajoutee = Ville.objects.filter(ville_nom=form.cleaned_data["gvvi_nom"])[0]
            form.cleaned_data.pop("gvvi_nom")
            graph_viaire_ville_information_instance.ville_id = ville_ajoutee.ville
            for clef in form.cleaned_data.keys():
                graph_viaire_ville_information_instance.__setattr__(clef, form.cleaned_data[clef])
            graph_viaire_ville_information_instance.save()
            for nom_ville_englobe in request.POST.getlist("gvvi_nom_ajout"):
                #création des villes qui n'existent pas
                try :
                    ville_instance = Ville()
                    ville_instance.ville_nom = nom_ville_englobe
                    ville_instance.save()
                except Exception:
                    pass
            ville_instance_englobe_liste = ville_instance_liste.filter(ville_nom__in=request.POST.getlist("gvvi_nom_ajout"))
            for ville_englobe in ville_instance_englobe_liste:
                #ajout dans la table rassemblement_ville des villes faisant parties d'une ville
                rassemblement_ville_instance = Rassemblement_ville()
                rassemblement_ville_instance.ville_englobante_id = ville_ajoutee.ville
                rassemblement_ville_instance.ville_id = ville_englobe.ville
                rassemblement_ville_instance.save()
            return valide(request)
        else:
            nom_villes = request.POST.getlist("gvvi_nom_ajout")
            return render(request, 'recuperateur_reseau_viaire/telecharge_liste_commune.html',
                      {'form': form, 'nom_villes_ajout' : nom_villes})