from django.shortcuts import render
from recuperateur_reseau_viaire.forms import Graph_viaire_ville_informationForm
from recuperateur_reseau_viaire.models import Graph_viaire_ville_information
from .view_update import update


def index(request):
    """
    Cette méthode permet de gérer entre :
     - la mise à jour de plusieurs lignes de la table
     - l'affichage de la table "Graph_viaire_ville_informationResource" de la base de données.

    :param request:
    :return: une HttpResponse de la page index.html en cas d'affichage de la table
    "Graph_viaire_ville_informationResource" le retour de la view update en cas de mise à jour de plusieurs lignes de la
     table en simultané. La création de la HttpResponse se fait à l'aide de django.template.loader.render_to_string().
    """
    if request.GET.__contains__("bouton") and request.GET.getlist("bouton")[0] == "update" \
            and request.GET.__contains__("update"):
        return update(request, request.GET.getlist("update"))
    else:
        form = Graph_viaire_ville_informationForm()
        graph_viaire_ville_information_list = Graph_viaire_ville_information.objects.all()
        return render(request, 'recuperateur_reseau_viaire/index.html',
                      {'list_graph': graph_viaire_ville_information_list, 'form': form})