from django.conf import settings
from django.shortcuts import render
from recuperateur_reseau_viaire.admin import Graph_viaire_ville_informationResource
from recuperateur_reseau_viaire.forms import Graph_viaire_ville_informationForm_export
from recuperateur_reseau_viaire.models import Graph_viaire_ville_information
from .view_valide import valide

def export(request):
    """
    Cette méthode permet de créer un formulaire d'exportation de la base de donnée au format choisi disponible.

    :param request:
    :return:
    """
    if request.method == 'POST':
        form_e = Graph_viaire_ville_informationForm_export(request.POST,
                                                           initial={'formats_exports': format})
        if form_e.is_valid():
            sgbd_donnees = getattr(Graph_viaire_ville_informationResource().export(),
                                   Graph_viaire_ville_information.formats_exports[
                                       int(form_e.cleaned_data['choix_format_export'])][1])()
            fichier = open(settings.REGISTER_DIR + "/export_sgbd." + Graph_viaire_ville_information.formats_exports[
                int(form_e.cleaned_data['choix_format_export'])][1].removeprefix("get_"), "w")
            fichier.write(sgbd_donnees)
            fichier.close()
            graph_viaire_ville_information_instance = Graph_viaire_ville_information()
            return valide(request)
    else:

        form_e = Graph_viaire_ville_informationForm_export()
        return render(request, 'recuperateur_reseau_viaire/export.html', {'form_e': form_e})