import os

from django.conf import settings
from django.shortcuts import render
from recuperateur_reseau_viaire.forms import Graph_viaire_ville_informationForm_delete
from recuperateur_reseau_viaire.models import Graph_viaire_ville_information, Rassemblement_ville
from .view_valide import valide

def delete(request, graph_id):
    """
    Cette méthode permet de supprimer une ligne de la table Graph_viaire_ville_information ainsi que les lignes
    de la table Rassemblement_ville qui y sont attachées.

    :param request : la requêtes de l'utilisateur
    :param graph_id : l'identifiant de la table de la ligne de la table Graph_viaire_ville_information
    :return:
    """
    graph_viaire_ville_information_instance = Graph_viaire_ville_information.objects.filter(id=graph_id)[0]
    if request.method == 'POST':
        form_u = Graph_viaire_ville_informationForm_delete(request.POST,
                                                           initial={'valeur': graph_viaire_ville_information_instance})
        if form_u.is_valid():
            graph_viaire_ville_information_instance.gvvi_nom = form_u.cleaned_data['gvvi_nom']
            graph_viaire_ville_information_instance.gvvi_nb_intersection = form_u.cleaned_data['gvvi_nb_intersection']
            if os.path.isfile(os.path.join(settings.REGISTER_DIR, form_u.cleaned_data['gvvi_nom'] + ".graphml")):
                os.remove(os.path.join(settings.REGISTER_DIR, form_u.cleaned_data['gvvi_nom'] + ".graphml"))
            graph_viaire_ville_information_instance.delete()
            #suppression Rassemblement ville
            ville_rassemblements_liste_instance = Rassemblement_ville.objects.\
                filter(ville_englobante=graph_viaire_ville_information_instance.ville_id)
            for ville_rassemblement_instance in ville_rassemblements_liste_instance:
                ville_rassemblement_instance.delete()
            return valide(request)
    else:
        form_u = Graph_viaire_ville_informationForm_delete(initial={'valeur': graph_viaire_ville_information_instance})
        return render(request, "recuperateur_reseau_viaire/delete.html", {'form_d': form_u})