# Generated by Django 4.1.2 on 2022-10-31 08:23

from django.db import migrations

from OSM_outils.OSMnx_recuperation_graph_information import OSMnx_recuperation_graph_information
from OSM_outils.OMSnx_enregistrement import OMSnx_enregistrement

def ajoute_donnees_nouvelle_colonne(apps, schema_editor):
    """
    Cette méthode permet de faire une migration de donnée pour les nouvelles colonnes ajoutées sur les fractales

    """
    graph_viaire_ville_information = apps.get_model('recuperateur_reseau_viaire', 'Graph_viaire_ville_information')
    for graph in graph_viaire_ville_information.objects.all():
        G = OMSnx_enregistrement.lire_graphe(graph.gvvi_nom)
        osmnx_var = OSMnx_recuperation_graph_information(G)

        graph.gvvi_d0_fractal_capacite_dimension = osmnx_var.\
            get_d0_fractal_capacite_dimension(G)["gvvi_d0_fractal_capacite_dimension"]
        graph.gvvi_d1_information_dimension = osmnx_var.\
            get_d1_information_dimension(G)["gvvi_d1_information_dimension"]
        graph.gvvi_d2_correlation_dimension = osmnx_var.\
            get_d2_correlation_dimension(G)["gvvi_d2_correlation_dimension"]

        graph.save()

class Migration(migrations.Migration):

    dependencies = [
        ('recuperateur_reseau_viaire', '0014_graph_viaire_ville_information_gvvi_d0_fractal_capacite_dimension_and_more'),
    ]

    operations = [
        migrations.RunPython(ajoute_donnees_nouvelle_colonne)
    ]
