from django.test import TestCase
from OSM_outils.OSMnx_recuperation_graph_information import OSMnx_recuperation_graph_information

class OSMnx_recuperation_graph_informationTestCase(TestCase):
    """
    Le but de cette classe de test est de vérifier les informations renvoyées depuis la méthode
    recuperation_information_graphe.

    """
    def setUp(self) -> None:
        self.G = OSMnx_recuperation_graph_information.lire_graphe("Bolbec")


    def test_get_d0_fractal_capacite_dimension(self):
        """
        Cette méthode a pour but de tester la méthode get_d0_fractal_capacite_dimension en vérifiant son retour
        et sa création de r_square. Nous comparons la valeur avec celle trouvée par l'algorithme de Michele Tirico.
        """
        oSMnx_recuperation_graph_information = OSMnx_recuperation_graph_information(self.G)
        d0_capacite_dimension = oSMnx_recuperation_graph_information.\
        get_d0_fractal_capacite_dimension(None)['gvvi_d0_fractal_capacite_dimension']

        self.assertAlmostEqual(oSMnx_recuperation_graph_information.d0_R_carre, 0.9647483827928908)
        self.assertAlmostEqual(oSMnx_recuperation_graph_information.d0_R_carre, 0.999)
        self.assertAlmostEqual(d0_capacite_dimension, 1.7774835892967236)

    def test_get_d1_information_dimension(self):
        """
        Cette méthode a pour but de tester la méthode get_d1_information_dimension. Nous comparons la valeur avec
        celle trouvée par l'algorithme de Michele Tirico.
        """
        oSMnx_recuperation_graph_information = OSMnx_recuperation_graph_information(self.G)
        d1_information_dimension = oSMnx_recuperation_graph_information.\
        get_d1_information_dimension(None)['gvvi_d1_information_dimension']

        self.assertAlmostEqual(d1_information_dimension, 1.6387250059874718)

    def test_d2_correlation_dimension(self):
        """
        Cette méthode a pour but de tester la méthode d2_correlation_dimension. Nous comparons la valeur avec
        celle trouvée par l'algorithme de Michele Tirico.
        """
        oSMnx_recuperation_graph_information = OSMnx_recuperation_graph_information(self.G)
        d2_correlation_dimension = oSMnx_recuperation_graph_information.\
        d2_correlation_dimension("Marseille")['gvvi_d1_information_dimension']

        self.assertAlmostEqual(d2_correlation_dimension, 1.664)

