# Generated by Django 4.1.1 on 2022-10-06 13:58

from django.db import migrations


from OSM_outils.OSMnx_recuperation_graph_information import OSMnx_recuperation_graph_information

def ajoute_donnees_nouvelle_colonne(apps, schema_editor):
    """
    Cette méthode permet de faire une migration de donnée pour la nouvelle colonne ajoutée

    """
    graph_viaire_ville_information = apps.get_model('recuperateur_reseau_viaire', 'Graph_viaire_ville_information')
    for graph in graph_viaire_ville_information.objects.all():
        G = OSMnx_recuperation_graph_information.lire_graphe(graph.gvvi_nom)
        graph.gvvi_longueur_moyenne_rues = OSMnx_recuperation_graph_information.get_longueur_moyennes_rues(G)["gvvi_longueur_moyenne_rues"]
        graph.save()


class Migration(migrations.Migration):

    dependencies = [
        ('recuperateur_reseau_viaire', '0012_graph_viaire_ville_information_gvvi_longueur_moyenne_rues'),
    ]

    operations = [
        migrations.RunPython(ajoute_donnees_nouvelle_colonne)
    ]
