# Recuperateur_route_ville

## Introduction 
Ce projet à pour but d’analyser les réseaux viaires des villes. L’analyse doit être faite à l’aide de machine learning 
qui utilisera les données récoltées sur openstreetmap par l’intermédiaire de OSMnx. 

Cette analyse permettra de définir :
- si un graph est la représentation d'un réseau viaire d'une ville
- agrandir le réseau viaire d'une ville en suivant sa logique actuel
- créer des réseaux viaires de villes en appréhendant les différences entre les pays. En effet, les villes des différents 
pays n'ont peut-être pas les mêmes définitons de ce qu'est une ville 

## Le fonctionnement du projet

La première chose à faire est de créer un environnement python et tlécharger les packages grâce au fichier 
"requirements.txt".
Il faut ensuite lancer le serveur web django grâce à la commande suivante : 
- python manage.py runserver

Il est possible d'ajouter automatiquement des colonnes à la table Graph_viaire_ville_information.
Pour ça nous allons utiliser les scripts shell disponible dans le dossier "Shell_directory".
Il est composé de deux fichiers bash :
- Un fichier "initialise_ajout_colonne". Il va nous demander les informations importantes pour la création de la 
nouvelle colonne. Il va aussi initialiser la création d'une nouvelle fonction dans la classe "OSMnx_recuperation_graph_information".
C'est une fonction qui permet de récupérer les informations sur le graphe pour remplir la nouvelle table.
- Un fichier ajout_colonne_in_graph_db qui lui va faire la migration de schéma, de donnée, mais également changer les 
différents fichiers nécessaires.

## Le travail de thèse de Michele Tirico (graphanalysis)

Mon projet va réutiliser le projet graphanalysis, qui a lui même besoin d'autres projets comme :
  - [graphanalysis](https://github.com/MicheleTirico/graphanalysis)
  - [graphstreamanalysis](https://github.com/MicheleTirico/graphstreamanalysis)
  - [graphgenerator](https://github.com/MicheleTirico/graphgenerator)
  - [graphtools](https://github.com/MicheleTirico/graphtools)

Tous ses projets vont être organisés avec git submode et l'ajout du framework de support maven pour les programmes java.

## La structure du projet

La structure du projet s'organise entre plusieurs projets principaux :
- Le projet basé sur django
  - [graphanalysis](https://github.com/MicheleTirico/graphanalysis)
    - [graphstreamanalysis](https://github.com/MicheleTirico/graphstreamanalysis)
    - [graphgenerator](https://github.com/MicheleTirico/graphgenerator)
    - [graphtools](https://github.com/MicheleTirico/graphtools)

Le tout géré par un Docker 


## Les outils utilisés

- [OSMnx](https://github.com/gboeing/osmnx) 
Boeing, G. 2017. OSMnx: New Methods for Acquiring, Constructing, Analyzing, and Visualizing Complex Street Networks. 
Computers, Environment and Urban Systems 65, 126-139. doi:10.1016/j.compenvurbsys.2017.05.004
- [OpenStreetMap](https://www.openstreetmap.org/)
- [overpass](https://overpass-turbo.eu/)
- [django](https://www.djangoproject.com/)
- [graphanalysis](https://github.com/MicheleTirico/graphanalysis)


