# Documentation  
## Table des matières
1. [Introduction](#introduction)
2. [Développeurs](#develloppers)
   1. [Procédures](#develloppers_procedures)
   2. [Messages d’erreur courant et information pour les résoudre](#develloppers_erreurs)
3. [Utilisateurs](#utilisateurs)
   1. [Procédures](#utilisateurs_procedures)
   2. [Messages d’erreur courant et information pour les résoudre](#utilisateurs_erreurs)
4. [Glossaire](#glossaire)
5. [Informations Connexes](#informations_connexes)
   1. [Arborescence du projet](#info_arborescence)
   2. [Les outils utilisés](#info_outils)

## Introduction <a name="introduction"></a>
Ce Projet a pour but de stocker en local les graphes viaires des villes ainsi que les mesures qui leur sont associées.

## Développeurs <a name="develloppers"></a>

Cette partie "développeurs" explique l'ajout de colonnes à la table 
"Graph_viaire_ville_information", ainsi que des erreurs qui peuvent en découler.

### Procédures <a name="develloppers_procedures"></a>

Pour ajouter de nouvelles colonnes dans la base de données, il vous faut suivre les actions suivantes : 

- lancer le script bash « initialise_ajout_colonne.sh » qui demande les informations suivantes :
  - le nom de la nouvelle colonne
  - le type de la nouvelle colonne
  - le nom de la fonction que le script créé dans la classe "OSMnx_recuperation_graph_information"
  - le nom du fichier test qui servira à tester la nouvelle fonction précédemment créée
- le script terminé, il faut ensuite : 
  - modifier la nouvelle fonction dans la classe "OSMnx_recuperation_graph_information" qui par défaut retourne zéro
  - Modifier le fichier test qui par défaut lève une erreur comme suis : « 1 != 0 »
- Après avoir modifié les fichiers, il faut lancer le script « ajout_colonne_in_graph_db.sh » qui va se charger de créer : 
  - les fichiers de migrations situés dans « recuperateur_reseau_viaire/migrations »
  - la migration du modèle
  - la migration de données
  - la modification du fichier html principal de « recuperateur_reseau_viaire » situé dans le dossier « recuperateur_reseau_viaire/templates »
  - Il vous propose d’ajouter les fichiers de migration au Git

### Messages d’erreur courants et information pour les résoudre <a name="develloppers_erreurs"></a>

#### Voici comment résoudre les erreurs pendant l'utilisation du script bash « ajout_colonne_in_graph_db.sh »

- Comment faire si le message suivant s'affiche : « Vous n'êtes pas dans le bon dossier courant » :

  - Cette erreur arrive lorsque vous ne lancez pas le script dans le dossier « Shell_directory ».
  - Pour résoudre cette erreur, il faut lancer ce script en étant dans le dossier « Shell_directory ».



- Comment faire si le message suivant s'affiche : « le fichier de sauvegarde de vos choix "sauvegarde_var" n'existe pas ».
  - Cette erreur arrive si lorsque le script est lancé le fichier « sauvegarde_var » n'est pas présent dans le dossier 
  courant (« Shell_directory »).

  - Pour résoudre cette erreur, il faut se situer dans le dossier « Shell_directory » et lancer le script 
  « initialise_ajout_colonne.sh », qui créé le fichier.


- Comment faire si le message suivant s'affiche : « La migration de données n'a pas fonctionné ». 
  - Cette erreur arrive si lors de la migration de donnée le fichier de migration [numéro]_auto_[date]_[heure].py a une 
  erreur de levée. Cette erreur peut provenir soit du fichier en lui-même, soit de la méthode utilisée venant de 
  « OSMnx_recuperation_graph_information ».

  - Pour résoudre cette erreur, il faut :
    1. modifier son code en conséquence de l'erreur affichée soit dans la nouvelle méthode de récupération de données que
    vous avez créée dans la classe « OSMnx_recuperation_graph_information » soit modifier le fichier de 
    migration [numéro]_auto_[date]_[heure].py
    2. relancer le script «ajout_colonne_in_graph_db.sh»


- Comment faire si le message suivant s'affiche : « Pour faire tourner ce programme, vous devez utiliser 
l’environnement virtuel possédant django ». 
  - Cette erreur arrive si vous n'utilisez pas d'environment virtuel avec au minimum django d'installé.
  - Pour résoudre cette erreur, il faut :
    1. créer un environnement virtuel s'il n'existe pas déjà : « python[3] -m venv [nom du dossier de l’environnement virtuel]»
    2. lancer l’environnement virtuel : « source  [nom du dossier de l’environnement virtuel]/bin/activate»
    3. installer les librairies requises s'ils ne sont pas déjà installées : « pip install -r requirements.txt »
    4. relancer le script «ajout_colonne_in_graph_db.sh»


- Comment faire si le message suivant s'affiche : « Tous les tests du fichier test_[nom du fichier] ne sont pas passés ». 
  
  - Cette erreur arrive si un des tests présent dans le fichier test que vous avez choisi lève une erreur.
  - Pour résoudre cette erreur, il faut :
    1. faire en sorte que les tests réussissent en modifiant la méthode testée dans la classe 
    « OSMnx_recuperation_graph_information » ou en modifiant le fichier test dans 
    « OSM_outils/Tests/test_[nom_du_fichier_choisi].py »
    2. relancer le script «ajout_colonne_in_graph_db.sh»


## Utilisateurs <a name="utilisateurs"></a>

Cette partie "utilisateurs" va être destinée aux personnes souhaitant utiliser la base de données sans modification, 
ainsi que des erreurs qui peuvent en découler.

### Procédures <a name="utilisateurs_procedures"></a>

Pour se connecter à la base de données en utilisant l'interface web il faut :
- utiliser l'environnement virtuel mise à disposition et en installant les librairies requises dans le fichier 
"requirements.txt"
- utiliser le script python « manage.py » comme suis « python ./manage.py runserver »
- écrire dans la barre de lien d'un navigateur web le lien suivant donné par la commande précédente : 
« http://127.0.0.1:8000/ »

Pour ajouter une nouvelle ville à la base de données, il faut :
- lancer l'interface web de la base de donnée décrite ci-dessus
- appuyer sur le bouton « Ajout » en bas de la page
- entrer dans la barre entrée de texte « nom de la ville : » le nom de la ville que vous souhaitez télécharger
- appuyer sur le bouton « créer »
- attendre de voir la page ayant pour texte : « Votre action a bien été enregistrée » 

Pour ajouter un graph viaire composé de plusieurs villes, il faut :
- lancer l'interface web de la base de donnée décrite ci-dessus
- appuyer sur le bouton « Ajout » en bas de la page
- appuyer sur le bouton « ajouter ville » autant de fois qu'il y a de villes
- donner un nom au rassemblement de ville dans l'entrée text devant le text : « Nom de l'ensemble des communes : »
- remplir les autres entrées textes du nom des villes
- appuyer sur le bouton « créer »
- attendre de voir la page ayant pour texte : « Votre action a bien été enregistrée » 

Pour supprimer une ville de la base de données, il faut :
- lancer l'interface web de la base de données décrite ci-dessus
- appuyer sur le bouton Delete au bout de la ligne de la ville que vous voulez supprimer

Pour exporter la table « Graph_viaire_ville_information », il faut :
- se connecter à la base de donnée django et appuyer sur le lien « exporter »
- Le lien emmène vers un formulaire proposant une liste de format possible d'export
- choisissez-en un et appuyez sur le bouton exporter
- le fichier est téléchargé dans le dossier « Data ».

Pour mettre à jour une ville de la base de donnée, il faut :
- appuyer sur le lien « update » au bout de la ligne de la ville voulue, qui mène vers un formulaire
- Le formulaire propose pour chacune des colonnes de la base de donnée : 
  - soit de la modifier le champ à la main
  - soit en cochant la case recalculer grâce à la méthode présente dans « OSMnx_recuperation_graph_information.py »
- validez ensuite en appuyant sur le bouton valider

Pour mettre à jour plusieurs villes de la base de donnée, il faut :
- selectionner les villes à modifier en cochant la case au début de la ligne des villes. Il est possible de selectionner
toutes les villes en appuyant sur la case à cocher en haut à gauche du tableau.
- le formulaire est le même que pour la modification d'une ville à la différence près que les valeurs entrés manuels 
ne sont pas obligatoires. Les champs non remplis ne sont donc pas modifiés, si vous les remplissez la valeur entrée sera
donnée à chaque ville. Le but de la case à cocher reste le même, la modification est, elle aussi, utilisé sur toutes 
les villes. 

### Messages d’erreur courant et information pour les résoudre <a name="utilisateurs_erreurs"></a>

#### Voici comment résoudre les erreurs pendant le téléchargement de nouvelles villes


- Comment faire si le message suivant s'affiche : « ville non trouvée ». 
  - Cette erreur arrive si le nom entré n'est pas 
  trouvé par nominatim, que nominatim n'a pas trouvé de frontière associée au nom ou que la ville n'a pas assez de rues.
  - Pour résoudre cette erreur, il faut :
    1. soit utiliser le nom reconnu par nominatim sur son site, ce nom peux être trouvé sur la carte qui affiche les noms de communes qu'il reconnait.
    2. soit la ville ne possède pas de frontière ou a un réseau de rues trop petit, celle ville ne peut donc pas 
    fonctionner avec notre projet.


- Comment faire si le message suivant s'affiche : « ville déjà enregistrée dans la base de données »
  - Cette erreur arrive si vous voulez télécharger une ville qui est déjà enregistrée dans la base de données.
  - Pour résoudre cette erreur, il faut supprimer la ville de la base de données avant de la re-télécharger.
## Glossaire <a name="glossaire"></a>
glossaire

## Informations Connexes <a name="informations_connexes"></a>

### Arborescence du projet <a name="info_arborescence"></a>

Le projet est ordonné de la manière suivante : la racine contient le dossier avec le code ainsi que des
fichiers libre office donnant des informations sur le projet. 

Le Dossier contenant le code est ordonné en modules.
- Le dossier « Data » dans lequel nous mettons les représentations des graphes viaires au format « graphml ».
- Le module « OSM_outils » dans lequel toutes les opérations sur « OpenStreetMap » sont effectuées, c'est-à-dire :
  - « OMSnx_enregistrement.py » qui se charge de télécharger les informations sur « OpenStreetMap » grâce à la 
  librairie « OSMnx ».
  -  « OSMnx_recuperation_graph_information.py » qui rassemble toutes les opérations d'extraction d'information des 
  graphes.
  - Le dossier « Tests » dans lequel tous les tests du module sont rassemblés.
  - Le dossier « CorrelationDimension_Michele_Tirico_Java » qui calcule la Correlation de la Dimension fractale du graph. 
  Son arborescence est faite grâce à l'aide de l'outil de gestion et d'automatisation de production des projets 
  logiciels : Maven.
- Le dossier « recuperateur_reseau_viaire » qui est le module de gestion de la table principale 
« Graph_viaire_ville_information » tel que :
  - La gestion des migrations de la table
  - les pages html
  - les formulaires
  - le modèle
  - les urls
  - la gestion de l'affichage
- Le dossier « Shell_directory » dans le quelle il y a les scripts bash permettant les migrations de la table 
 « Graph_viaire_ville_information » (« initialise_ajout_colonne.sh » et « initialise_ajout_colonne.sh »). Il y a 
 également le script « nb_rues_avec_attr.sh » qui permet de connaitre la proportion de présence d'un attribut dans les 
rues d'un fichier graphml
- le dossier « static » qui lui contient le code css ainsi que les images du site
- le dossier « template » contenant le code html partagé par tous les modules

### Les outils utilisés <a name="info_outils"></a>

- [OSMnx](https://github.com/gboeing/osmnx) 
Boeing, G. 2017. OSMnx: New Methods for Acquiring, Constructing, Analyzing, and Visualizing Complex Street Networks. 
Computers, Environment and Urban Systems 65, 126-139. doi:10.1016/j.compenvurbsys.2017.05.004
- [OpenStreetMap](https://www.openstreetmap.org/)
- [overpass](https://overpass-turbo.eu/)
- [django](https://www.djangoproject.com/)
- [graphanalysis](https://github.com/MicheleTirico/graphanalysis)
- [Maven](https://maven.apache.org/what-is-maven.html)