# Generated by Django 4.1.1 on 2022-10-06 12:49

from django.db import migrations


from OSM_outils.OSMnx_recuperation_graph_information import OSMnx_recuperation_graph_information
from OSM_outils.OMSnx_enregistrement import OMSnx_enregistrement

def ajoute_donnees_nouvelle_colonne(apps, schema_editor):
    """
    Cette méthode permet de faire une migration de donnée pour la nouvelle colonne ajoutée

    """
    graph_viaire_ville_information = apps.get_model('recuperateur_reseau_viaire', 'Graph_viaire_ville_information')
    for graph in graph_viaire_ville_information.objects.all():
        G = OMSnx_enregistrement.lire_graphe(graph.gvvi_nom)
        graph.gvvi_connectivity = OSMnx_recuperation_graph_information.nom_fonction(G)["gvvi_connectivity"]
        graph.save()


class Migration(migrations.Migration):

    dependencies = [
        ('recuperateur_reseau_viaire', '0006_graph_viaire_ville_information_gvvi_connectivity'),
    ]

    operations = [
        migrations.RunPython(ajoute_donnees_nouvelle_colonne)
    ]
