import os
import random

from django.conf import settings
from django.contrib.staticfiles.testing import StaticLiveServerTestCase
from recuperateur_reseau_viaire.models import Graph_viaire_ville_information, Ville, Rassemblement_ville
from selenium.webdriver.common.by import By
from selenium.webdriver.firefox.webdriver import WebDriver
from selenium.webdriver.support import expected_conditions as EC
from selenium.webdriver.support.ui import WebDriverWait


class export_formulaireTests(StaticLiveServerTestCase):

    selenium = None

    @classmethod
    def setUpClass(cls):
        """
        Le but de cette méthode est d'initialiser selenium avant le début des tests de la classe

        """
        super().setUpClass()
        cls.selenium = WebDriver()
        cls.selenium.implicitly_wait(10)

    @classmethod
    def tearDownClass(cls):
        """
        Le but de cette méthode est de fermer selenium à la fin des tests de la classe
        """
        cls.selenium.quit()
        super().tearDownClass()

    def setUp(self) -> None:
        """
        Le but de cette méthode est que selenium soit dans l'index du site à chaque test
        """
        self.nom_ville_test_a = "commune"
        self.nom_ville_test_b = "ville"
        self.nom_ville_test_c = "sous ville 2"
        def ajoute_ville_et_gvvi(nom_ville):
            """
            Le but de cette méthode est de créer une instance ville de nom nom ville et une instance
            Graph_viaire_ville_information ayant pour ville la ville créé.
            :param nom_ville: nom de la ville à créer
            """
            Ville.objects.create(ville_nom=nom_ville)
            valeur = random.randint(-5, -1)
            Graph_viaire_ville_information.objects.create(gvvi_cout=valeur, gvvi_robustesse=valeur,
                                                          gvvi_d2_correlation_dimension=valeur,
                                                          gvvi_d1_information_dimension=valeur,
                                                          gvvi_d0_fractal_capacite_dimension=valeur,
                                                          gvvi_longueur_moyenne_rues=valeur,
                                                          gvvi_tree_vs_complete_graph=valeur,
                                                          gvvi_org_plan_vs_organized=valeur, gvvi_connectivity=valeur,
                                                          gvvi_degre_moyen=valeur, gvvi_diametre=valeur,
                                                          gvvi_nb_intersection=valeur,
                                                          ville=Ville.objects.get(ville_nom=nom_ville))

        # création d'une instance de Ville
        ajoute_ville_et_gvvi(self.nom_ville_test_a)
        ajoute_ville_et_gvvi(self.nom_ville_test_b)
        Ville.objects.create(ville_nom=self.nom_ville_test_c)
        Rassemblement_ville.objects.create(ville_englobante=Ville.objects.get(ville_nom=self.nom_ville_test_a),
                                           ville=Ville.objects.get(ville_nom=self.nom_ville_test_b))
        Rassemblement_ville.objects.create(ville_englobante=Ville.objects.get(ville_nom=self.nom_ville_test_a),
                                           ville=Ville.objects.get(ville_nom=self.nom_ville_test_c))
        self.selenium.get('%s%s' % (self.live_server_url, '/recuperateur_reseau_viaire/'))

    def test_export_fichier(self):
        """
        Cette méthode a pour but de vérifier que l'exportation fonctionne bien
        """
        nom_fichier_export = "export_sgbd.csv"
        with self.subTest('test bouton fonctionne bien'):
            self.selenium.find_element(
                By.LINK_TEXT, 'exporter'
            ).click()
            self.assertTrue(self.selenium.current_url.endswith("/recuperateur_reseau_viaire/export/"))

        with self.subTest("le fichier d'enregistremment est à la base dans le dossier Data"):
            #vérification du chemin d'enregistrement des fichiers
            self.assertTrue(settings.REGISTER_DIR.__str__().endswith("/Projet/Data"))

        with self.settings(REGISTER_DIR=os.path.join(settings.BASE_DIR, 'recuperateur_reseau_viaire/Tests/Data')):
            #permet de sauvegarder le fichier de tests dans le dossier Data de test
            with self.subTest("sauvegarde fichier n'existe pas"):
                #supprimmer l'ancien fichier
                try:
                    os.remove(settings.REGISTER_DIR + "/" + nom_fichier_export)
                except FileNotFoundError:
                    pass

                # valider le formulaire avec l selection par défaut
                WebDriverWait(self.selenium, 10).until(
                    EC.element_to_be_clickable((By.XPATH, "//button[@class='btn btn-success']")))
                self.selenium.find_element(By.XPATH, "//button[@class='btn btn-success']").submit()

                # vérifier que le formulaire est valide
                WebDriverWait(self.selenium, 10).until(
                    EC.text_to_be_present_in_element((By.CSS_SELECTOR, "h1"), "Votre action a bien été enregistré"))

            with self.subTest("fichier bien enregistré"):
                #vérifier que le fichier export.csv est bien enregistré dans le dossier Data
                self.assertTrue(nom_fichier_export in os.listdir(settings.REGISTER_DIR))

        with self.subTest("retour à la page principale"):
            # appuyer sur le bouton de validation
            self.selenium.find_element(By.XPATH, "//a[@class='btn btn-success']").click()
            self.assertTrue(self.selenium.current_url.endswith("/recuperateur_reseau_viaire/"))