import math
from django.test import TestCase
from OSM_outils.OSMnx_recuperation_graph_information import OSMnx_recuperation_graph_information
import osmnx as ox
from django.conf import settings
from OSM_outils.OMSnx_enregistrement import OMSnx_enregistrement

class OSMnx_recuperation_graph_informationTestCase(TestCase):
    def setUp(self) -> None:
        self.G = ox.load_graphml(settings.REGISTER_DIR + "/exemple.graphml")

    def test_lire_graph_ville_inexistant(self):
        """
        Test la méthode de lecture de graph villaire avec un nom de ville inexistant. Une levée d'erreur est attendue

        """
        self.assertRaises(FileNotFoundError, OMSnx_enregistrement.lire_graphe, "aazerty")

    def test_lire_graph_basique(self):
        """
        Test la méthode de lecture de graph pour savoir si la lecture fonctionne

        """
        G = OMSnx_enregistrement.lire_graphe("exemple")

        print("edges : ", G.nodes)
        self.assertIsNotNone(G.nodes[411610215])
        self.assertIsNotNone(G.nodes[411610220])
        print("edges : ", G.edges)
        self.assertIsNotNone(G.edges[411610215, 411610220, 0])

    def test_graph_mise_a_lechelle(self):
        """
        Ici on test la mise à l'échelle du graph lors de l'initialisation de OSMnx_recuperation_graph_information.

        :return:
        """
        recuperation_graph_information = OSMnx_recuperation_graph_information(self.G)

        self.assertEqual(recuperation_graph_information.size_space, [1000, 1000])
        self.assertEqual(recuperation_graph_information.maxSize, 1000)
        coord_trouve_avec_algo_michele = [[0, 999], [299, 0]]
        for node in recuperation_graph_information.G_scale.nodes().data():
            coord = [math.floor(node[1]["x"]), math.floor(node[1]["y"])]
            self.assertTrue(coord in coord_trouve_avec_algo_michele, "la remise à l'echelle du graph à échoué => x : "
                            + str(coord[0]) + " y : " + str(coord[1]))
            coord_trouve_avec_algo_michele.remove(coord)
        self.assertEqual(coord_trouve_avec_algo_michele, [])
