from django.test import TestCase
from OSM_outils.OSMnx_recuperation_graph_information import OSMnx_recuperation_graph_information
from OSM_outils.OMSnx_enregistrement import OMSnx_enregistrement

class OSMnx_recuperation_graph_informationTestCase(TestCase):
    """
    Le but de cette classe de test est de vérifier les informations renvoyées depuis la méthode
    recuperation_information_graphe.

    """
    def setUp(self) -> None:
        pass

    def test_de_base(self):
        """
        Cette méthode représente un test model
        """
        arbre_euclidian = OMSnx_enregistrement.lire_graphe("euclideanTree")
        self.assertEqual(OSMnx_recuperation_graph_information.get_cout(arbre_euclidian)['gvvi_cout'], 1)

        grille = OMSnx_enregistrement.lire_graphe("grid")
        self.assertAlmostEqual(OSMnx_recuperation_graph_information.get_cout(grille)['gvvi_cout'], 2/3)
