# env/bin/bash sh

#le tableau de choix possible de types pour la nouvelle variable
declare -A choix_vers_type=([BigIntegerField]="int32" [BooleanField]="bool" [FloatField]="float" [IntegerField]="int32")
declare choix

for i in "${!choix_vers_type[@]}"
do
        choix[${#choix[@]}]=$i
done

echo "${choix[@]}"


function demande_information()
{
	# cette fonction permet de demander à l'utilisateur le type et le nom de la nouvelle colonne à rajouter dans
	# la base de donnée django

	#le préfixe de la variable dans la base de donnée
  prefixe_nom_variable="gvvi_"
  #le préfixe des fonctions de récupérations d'information
  prefixe_nom_fonction="get_"
  #chemin vers le fichier de sauvegarde
  fichier_decision_utilisateur_ajout_colonne=./sauvegarde_var

	#demande le nom de la variable sans le préfixe
	read -p "quelle nom de variable choisissez vous ? " nomvariable
	nomvariable=$prefixe_nom_variable$nomvariable

	echo "choisissez le type de la variable django dans la liste suivante :"
	for (( i=0; i<${#choix[@]}; i++ ));
  do
    echo "${choix[$i]} : $i"
  done
  read -p "entrez le numéro du type de votre choix : " id_choix

  #récupére le nom de la méthode de remplissage des données et on y ajoute le préfixe get_
  read -p "Donnez le nom de la méthode de récupération d'information dans la classe OSMnx_recuperation_graph_information : " nom_fonction
  nom_fonction=$prefixe_nom_fonction$nom_fonction

  read -p "Donnez le nom du fichier test pour cette fonction : " nom_fichier_test
  #ajout des préfixes et des suffixes du fichier test
  nom_fichier_test="test_$nom_fichier_test.py"

  #remplissage du fichier tampon d'attente
  echo "nomvariable	$nomvariable" > $fichier_decision_utilisateur_ajout_colonne
  echo "type		${choix[$id_choix]}   ${choix_vers_type[${choix[$id_choix]}]}" >> $fichier_decision_utilisateur_ajout_colonne
  echo "nom_fonction	$nom_fonction" >> $fichier_decision_utilisateur_ajout_colonne
  echo "nom fichier $nom_fichier_test" >> $fichier_decision_utilisateur_ajout_colonne
}

function ajoute_fonction_OSMnx_recuperation_graph_information() {
  # cette fonction a pour but de rajouter à la liste de fonction une nouvelle méthode de récupération de données vide.
  # Cela pour permettre d'éviter les erreurs de changement de noms
  # elle prend en paramètre le nom de la variable et le nom de la fonction à créer
  nomvariable=$1
  nom_fonction=$2

  #chemin vers le fichier d'origine
  chemin_classe_extracteur_information=./../OSM_outils/OSMnx_recuperation_graph_information.py
  #chemin vers le fichier model de fonction
  chemin_vers_fichier_model_fonction=./fonction_fichier_model

  #ajoute un retour chariot entre les méthodes
  echo "" >> $chemin_classe_extracteur_information
  cat $chemin_vers_fichier_model_fonction | sed -s "s/&&nom_variable&&/$nomvariable/g" | sed -s "s/&&nom_méthode_recup_info&&/$nom_fonction/g" >> $chemin_classe_extracteur_information

}

function ajoute_fichier_test_OSMnx_recuperation_graph_information() {
  # Cette méthode permet de créer le fichier de test initiale de la nouvelle méthode
  # ajouté à la classe OSMnx_recuperation_graph_information
  # Elle prend en paramètre le nom du fichier au qu'elle elle ajoute le préfixe "test_"
  nom_fichier_test=$1

  chemin_vers_fichiers_tests=./../OSM_outils/Tests/"$nom_fichier_test"
  chemin_vers_fichier_model_tests=./model_test_OSMnx_recuperation_graph_information

  cat $chemin_vers_fichier_model_tests > $chemin_vers_fichiers_tests
}

echo "Nous allons ajouter une fonction dans la classe OSMnx_recuperation_graph_information afin de pouvoir l'utiliser
lors de la migration de données. vous devez maintenant la modifier."

demande_information

ajoute_fonction_OSMnx_recuperation_graph_information $nomvariable $nom_fonction

ajoute_fichier_test_OSMnx_recuperation_graph_information $nom_fichier_test