# Documentation  
## Table des matières
1. [Introduction](#introduction)
2. [Developers](#develloppers)
   1. [Procédures](#develloppers_procedures)
   2. [Messages d’erreur courant et information pour les résoudres](#develloppers_erreurs)
3. [Utilisateurs](#utilisateurs)
   1. [Procédures](#utilisateurs_procedures)
   2. [Messages d’erreur courant et information pour les résoudres](#utilisateurs_erreurs)
4. [Glossaire](#glossaire)
5. [Informations Connexes](#informations_connexes)
    1. [Les outils utilisés](#info_outils)

## Introduction <a name="introduction"></a>
Ce Projet a pour but de stocker en local les graph viaires des villes ainsi que des mesures que nous trouvons 
importantes de garder sur une base de donnée. 

## Developers <a name="develloppers"></a>

Cette partie va être pour les personnes souhaitant ajouter des colonnes à la table Graph_viaire_ville_information,
ainsi que des erreurs qui peuvent en découler.

### Procédures <a name="develloppers_procedures"></a>

La procédure **P_Ajout_colonne**, permet de rajouter de nouvelles valeurs dans la base de donnée, pour cela nous devons 
suivre les actions suivantes :

- lancer le script bash « initialise_ajout_colonne.sh » qui demande les informations suivantes :
  - le nom de la nouvelle colonne
  - le type de la nouvelle colonne
  - le nom de la fonction à utiliser dans la classe OSMnx_recuperation_graph_information
- le script fini, il faut ensuite : 
  - modifier la nouvelle méthode dans la classe OSMnx_recuperation_graph_information qui par défaut retourne zéro
  - Modifier le fichier test qui par défaut lève une erreur comme suis : « 1 != 0 »
- Après avoir modifié les fichiers, il faut lancer le script « ajout_colonne_in_graph_db.sh » qui va se charger de : 
  - créer les fichiers de migrations situé dans « recuperateur_reseau_viaire/migrations »
  - la migration du modèle situé « recuperateur_reseau_viaire/models.py »
  - la migration de donné
  - la modification du fichier html principal de « recuperateur_reseau_viaire » situé : « recuperateur_reseau_viaire/templates »
  - Il vous propose d’ajouter les fichiers de migrations au Git

### Messages d’erreur courant et information pour les résoudres <a name="develloppers_erreurs"></a>

L'erreur **E_migration_erreur_code** peut arriver en utilisant le script « ajout_colonne_in_graph_db.sh ». 
Il est possible que malgré les tests la méthode ou la migration lève une erreur. 

(message d'erreur complet)

Pour résoudre cette erreur il faut :
- modifier son code en conséquence de l'erreur affiché
- supprimer les fichiers de migrations créés :
  - [numéro_unique]_graph_viaire_ville_information_gvvi_[nom_variable].py
  - [numéro_unique]_auto_[date]_[heure].py
  - supprimer les modifications apportées aux fichiers « models.py » et « index.html » de « recuperateur_reseau_viaire »
- relancer le script «ajout_colonne_in_graph_db.sh»

L'erreur **E_venv** peut arriver en utilisant le script « ajout_colonne_in_graph_db.sh » sans utiliser un environnement 
virtuel.

« Pour faire tourner ce programme vous dever utiliser l’environnement virtuel possédant django »

Pour résoudre cette erreur vous devez :
- créer un environnement virtuel s'il n'existe pas déjà : « python[3] -m venv [nom du dossier de l’environnement virtuel]»
- lancer l’environnement virtuel : « source  [nom du dossier de l’environnement virtuel]/bin/activate»
- installer les librairies requises s'ils ne sont pas déjà installées : « pip install -r requirements.txt »
- relancer le script «ajout_colonne_in_graph_db.sh»

L'erreur **E_test_raté** peut arriver en utilisant le script « ajout_colonne_in_graph_db.sh ».

« Tous les tests du fichier test_[nom du fichier] ne sont pas passé »

Pour résoudre cette erreur vous devez :
- faire en sorte que les tests réussissent en modifiant la méthode testée dans la classe 
« OSMnx_recuperation_graph_information » ou en modifiant le fichier test dans 
« OSM_outils/Tests/test_[nom_du_fichier_choisi].py »


## Utilisateurs <a name="utilisateurs"></a>

Cette partie va être pour les personnes souhaitant utiliser la base de donnée afin de stocker des données importantes
dans la table Graph_viaire_ville_information, ainsi que des erreurs qui peuvent en découler.

### Procédures <a name="utilisateurs_procedures"></a>

Pour utiliser la base de donnée il faut :
- utiliser l'environnement virtuel mise à disposition et en installant les librairies requises dans le fichier 
requirements.txt
- utiliser le script python « manage.py » comme suis « python ./manage.py runserver »
- écrire dans la barre de lien d'un navigateur web le lien suivant donné par la commande précédente : 
« http://127.0.0.1:8000/ »

Pour ajouter une nouvelle ville à la base de donnée, il faut :
- lancer l'interface web de la base de donnée décris ci-dessus
- entrer dans la barre entrée de texte « nom de la ville : » le nom de la ville que vous souhaitez télécharger
- appuyer sur le bouton valider
- attendre de voir la page ayant pout texte : « Votre action a bien été enregistré » 

Pour supprimer une ville de la base de donnée, il faut :
- lancer l'interface web de la base de donnée décris ci-dessus
- appuyer sur le bouton Delete au bout de la ligne de la ville que vous voulez supprimer

### Messages d’erreur courant et information pour les résoudres <a name="utilisateurs_erreurs"></a>

Lors du téléchargement de nouvelles villes, il est possible de voir une des erreurs suivantes :

Une erreur de connection :
« requests.exceptions.ConnectionError: HTTPSConnectionPool(host='dns.google', port=num): Max retries exceeded with 
url: /resolve?name=nominatim.openstreetmap.org (Caused by NewConnectionError('<urllib3.connection.HTTPSConnection 
object at addr>: Failed to establish a new connection: [Errno -2] Name or service not known'))
- pour résoudre ce problème il faut vous connecter à internet ».

Lors du téléchargement le message suivant peut s'afficher : « ville non trouvée ». Cela veut dire que nominatim 
n'a pas trouvé de ville ou de frontières associée au nom entré ou que OSMnx n'a pas trouvé de réseaux viaires 
assez importants ou aucun.


Pour régler cette erreur il faut soit modifier le nom de la ville, pour cela utilisez 
[nominatim](https://nominatim.openstreetmap.org/ui/search.html) pour trouver le nom qui est connu par lui, pour voir
que la ville ne possède pas de frontières, qu'elle n'existe pas ou qu'elle est trop petite.


Une autre erreur peut s'afficher « ville déjà enregistrée dans la base de donnée », si vous voulez retélécharger le 
fichier il vous faudra alors supprimer cette ville de la base de donnée, avant de pouvoir la re-télécharger.
## Glossaire <a name="glossaire"></a>
glossaire

## Informations Connexes <a name="informations_connexes"></a>

### Les outils utilisés <a name="info_outils"></a>

- [OSMnx](https://github.com/gboeing/osmnx) 
Boeing, G. 2017. OSMnx: New Methods for Acquiring, Constructing, Analyzing, and Visualizing Complex Street Networks. 
Computers, Environment and Urban Systems 65, 126-139. doi:10.1016/j.compenvurbsys.2017.05.004
- [OpenStreetMap](https://www.openstreetmap.org/)
- [overpass](https://overpass-turbo.eu/)
- [django](https://www.djangoproject.com/)
- [graphanalysis](https://github.com/MicheleTirico/graphanalysis)