# Generated by Django 4.1.2 on 2022-11-15 09:03

from django.db import migrations


from OSM_outils.OSMnx_recuperation_graph_information import OSMnx_recuperation_graph_information
from OSM_outils.OMSnx_enregistrement import OMSnx_enregistrement

def ajoute_donnees_nouvelle_colonne(apps, schema_editor):
    """
    Cette méthode permet de faire une migration de donnée pour la nouvelle colonne ajoutée

    """
    graph_viaire_ville_information = apps.get_model('recuperateur_reseau_viaire', 'Graph_viaire_ville_information')
    for graph in graph_viaire_ville_information.objects.all():
        G = OMSnx_enregistrement.lire_graphe(graph.gvvi_nom)
        graph.gvvi_cout = OSMnx_recuperation_graph_information.get_cout(G)["gvvi_cout"]
        graph.save()


class Migration(migrations.Migration):

    dependencies = [
        ('recuperateur_reseau_viaire', '0018_graph_viaire_ville_information_gvvi_cout'),
    ]

    operations = [
        migrations.RunPython(ajoute_donnees_nouvelle_colonne)
    ]
