from django import forms
from recuperateur_reseau_viaire.models import Graph_viaire_ville_information


class Graph_viaire_ville_informationForm_export(forms.Form):
    """
    Ce formulaire a pour but d'exporter la base de donnée sous un des formats possibles donné par la librairie import_export
    """
    choix_format_export = forms.ChoiceField(required=True, choices=[(0, "csv"), (1, "latex")])

    def __init__(self, *args, **kwargs):
        super(Graph_viaire_ville_informationForm_export, self).__init__(*args, **kwargs)
        initial_arguments = kwargs.get('initial', None)
        if initial_arguments:
            chaine_caractere_format = []
            for format in Graph_viaire_ville_information.formats_exports:
                chaine_caractere_format.append((format[0], format[1].removeprefix("get_")))
            super(Graph_viaire_ville_informationForm_export, self).__init__(*args, **kwargs)
            self.fields['choix_format_export'] = forms.ChoiceField(required=True,
                                                                   choices=chaine_caractere_format,
                                                                   initial=chaine_caractere_format[0])

    def clean_choix_format_export(self):
        data = self.cleaned_data['choix_format_export']
        return data