from django.test import TestCase
from recuperateur_reseau_viaire.forms import Graph_viaire_ville_informationFormUpdate
from recuperateur_reseau_viaire.models import Graph_viaire_ville_information, Ville
from django.http import QueryDict

class test_form_modification_Graph_viaire_ville_informationTestCase(TestCase):

    def setUp(self) -> None:
        """
        Créé une ligne dans la base de donnée Graph_viaire_ville_information au départ pour chaque test
        """
        self.nom_ville_test_a = "commune"
        self.nom_ville_test_b = "ville"
        def ajoute_ville_et_gvvi(nom_ville):
            Ville.objects.create(ville_nom=nom_ville)
            Graph_viaire_ville_information.objects.create(gvvi_cout=0, gvvi_robustesse=0,
                                                      gvvi_d2_correlation_dimension=0, gvvi_d1_information_dimension=0,
                                                      gvvi_d0_fractal_capacite_dimension=0,
                                                      gvvi_longueur_moyenne_rues=0, gvvi_tree_vs_complete_graph=0,
                                                      gvvi_org_plan_vs_organized=0, gvvi_connectivity=0,
                                                      gvvi_degre_moyen=0, gvvi_diametre=0, gvvi_nb_intersection=0,
                                                      ville=Ville.objects.get(ville_nom=nom_ville))
        #création d'une instance de Ville
        ajoute_ville_et_gvvi(self.nom_ville_test_a)
        ajoute_ville_et_gvvi(self.nom_ville_test_b)
        #graph_viaire_ville_information_instance.save()

    def test_creation_form_vide(self):
        """
        Ce teste créé un formulaire de modification de Graph_viaire_ville_information sans modification
         et doit être valide.
        """
        form = Graph_viaire_ville_informationFormUpdate()
        self.assertFalse(form.is_valid())

    def test_creation_form_aucune_modification(self):
        """
        Ce test créé un formulaire préremplit de modification sans y faire aucune modification
        """
        graph_viaire_ville_information_instance = Graph_viaire_ville_information.objects.get(ville_id = Ville.objects.get(ville_nom=self.nom_ville_test_a))
        str_queryDict = ""
        for sgbd_var in dir(graph_viaire_ville_information_instance):
            if sgbd_var.startswith("gvvi_"):
                str_queryDict = str_queryDict + sgbd_var.__str__() + "=" + getattr(graph_viaire_ville_information_instance, sgbd_var).__str__() + "&"
        str_queryDict = str_queryDict + "gvvi_nom=" + self.nom_ville_test_a
        entree_form = QueryDict(str_queryDict)
        form = Graph_viaire_ville_informationFormUpdate(entree_form)
        self.assertTrue(form.is_valid())

    def test_modification_form_modification_erreur_ville_existe_deja(self):
        """
        Ce test modifie le nom de la ville en un nouveau nom qui existe déjà
        """
        graph_viaire_ville_information_instance = Graph_viaire_ville_information.objects.get(
            ville_id=Ville.objects.get(ville_nom=self.nom_ville_test_a))
        str_queryDict = ""
        for sgbd_var in dir(graph_viaire_ville_information_instance):
            if sgbd_var.startswith("gvvi_"):
                str_queryDict = str_queryDict + sgbd_var.__str__() + "=" + getattr(
                    graph_viaire_ville_information_instance, sgbd_var).__str__() + "&"
        str_queryDict = str_queryDict + "gvvi_nom=" + self.nom_ville_test_b
        entree_form = QueryDict(str_queryDict)
        form = Graph_viaire_ville_informationFormUpdate(entree_form, initial={'valeur': graph_viaire_ville_information_instance})
        self.assertFalse(form.is_valid())
        self.assertTrue("ville ville déjà enregistrée dans la base de donnée" in form.errors["gvvi_nom"])