from django.shortcuts import get_object_or_404, render
import os
from django.conf import settings
# Create your views here.
from django.http import HttpResponse

from recuperateur_reseau_viaire.forms import Graph_viaire_ville_informationForm, \
    Graph_viaire_ville_informationFormUpdate, Graph_viaire_ville_informationForm_delete
from recuperateur_reseau_viaire.models import Graph_viaire_ville_information


def index(request):
    if request.method == 'POST':
        form = Graph_viaire_ville_informationForm(request.POST)
        graph_viaire_ville_information_instance = Graph_viaire_ville_information()
        if form.is_valid():
            for clef in form.cleaned_data.keys():
                graph_viaire_ville_information_instance.__setattr__(clef, form.cleaned_data[clef])
            graph_viaire_ville_information_instance.save()
            return render(request, 'recuperateur_reseau_viaire/valide.html',
                          {'instance' : graph_viaire_ville_information_instance})
    else:
        form = Graph_viaire_ville_informationForm()
    graph_viaire_ville_information_list = Graph_viaire_ville_information.objects.all()
    return render(request, 'recuperateur_reseau_viaire/index.html',
            {'list_graph' : graph_viaire_ville_information_list, 'form' : form})

def valide(request):
    return render(request, 'recuperateur_reseau_viaire/valide.html')

def update(request, graph_id):
    graph_viaire_ville_information_instance = Graph_viaire_ville_information.objects.filter(id=graph_id)[0]
    if request.method == 'POST':
        form_u = Graph_viaire_ville_informationFormUpdate(request.POST,
                                                          initial={'valeur' : graph_viaire_ville_information_instance})
        if form_u.is_valid():
            graph_viaire_ville_information_instance.gvvi_nom = form_u.cleaned_data['gvvi_nom']
            graph_viaire_ville_information_instance.gvvi_nb_intersection = form_u.cleaned_data['gvvi_nb_intersection']
            graph_viaire_ville_information_instance.save()
            return render(request, 'recuperateur_reseau_viaire/valide.html',
                          {'instance': graph_viaire_ville_information_instance})
    else:
        form_u = Graph_viaire_ville_informationFormUpdate(initial={'valeur' : graph_viaire_ville_information_instance})
        return render(request, "recuperateur_reseau_viaire/update.html", {'form_u' : form_u})

def delete(request, graph_id):
    graph_viaire_ville_information_instance = Graph_viaire_ville_information.objects.filter(id=graph_id)[0]
    if request.method == 'POST':
        form_u = Graph_viaire_ville_informationForm_delete(request.POST,
                                                          initial={'valeur': graph_viaire_ville_information_instance})
        if form_u.is_valid():
            graph_viaire_ville_information_instance.gvvi_nom = form_u.cleaned_data['gvvi_nom']
            graph_viaire_ville_information_instance.gvvi_nb_intersection = form_u.cleaned_data['gvvi_nb_intersection']
            if os.path.isfile(os.path.join(settings.REGISTER_DIR, form_u.cleaned_data['gvvi_nom'] + ".graphml")):
                os.remove(os.path.join(settings.REGISTER_DIR, form_u.cleaned_data['gvvi_nom'] + ".graphml"))
            graph_viaire_ville_information_instance.delete()
            return render(request, 'recuperateur_reseau_viaire/valide.html',
                          {'instance': graph_viaire_ville_information_instance})
    else:
        form_u = Graph_viaire_ville_informationForm_delete(initial={'valeur': graph_viaire_ville_information_instance})
        return render(request, "recuperateur_reseau_viaire/delete.html", {'form_d': form_u})

def atributs_graph(request, graph_id):
    graph = get_object_or_404(Graph_viaire_ville_information, graph_id)
    return render(request, 'recuperateur_reseau_viaire/graph_id.html', {'graph' : graph})
