import os
import numpy as np
import sys
import osmnx as ox
from Projet.OSM_outils import OSMnx_recuperation_graph_information


def ecrit_resultat_nouvelle_methode(python_type, nom_methode_osmn_recup, nom_variable_db, chemin_vers_data):
    """
    Ce programme a pour but de récupérer les informations des graphes grâce à la nouvelle méthode.
    Le retour de cette fonction est ensuite écrit dans un fichier afin de savoir si la méthode fonctione et la
    migration est possible, sinon elle écrit l'erreur détaillée.
    Elle prend en argument :
    - le type de la variable python
    - le nom de la méthode de récupération d'informations sur le graphe depuis la classe
    OSMnx_recuperation_graph_information
    - le nom de la variable dans la base de donnée
    Elle écrit dans le fichier nommé "retour_methode"

    :param python_type: le type des variables numpy à écrire
    :param nom_methode_osmn_recup: le nom de la méthode dans la classe OSMnx_recuperation_graph_information
    :param nom_variable_db: le nom de la variable à récupérer dans la base de donnée
    :return:
    """
    fichier = open("retour_methode", "w")
    #graph_viaire_ville_information_list = Graph_viaire_ville_information.objects.all()
    #graph_viaire_ville_information = apps.get_model('recuperateur_reseau_viaire', 'Graph_viaire_ville_information')
    tableau = np.array([], dtype=np.dtype(python_type))
    erreur = False
    for graph_file in os.listdir(os.path.join(chemin_vers_data)):
        if graph_file.endswith(".graphml"):
            G = ox.load_graphml(os.path.join(chemin_vers_data, graph_file))
            ox.plot_graph(G, filepath=graph_file + '.png', save=True, show=False)
            try:
                rep = OSMnx_recuperation_graph_information.OSMnx_recuperation_graph_information()
                tableau = np.append(tableau, getattr(rep, nom_methode_osmn_recup)(G)[nom_variable_db])
            except Exception as err:
                erreur = True
                print("graph : ", graph_file, "err : ", err)
                fichier.close()
                break
    if not erreur:
        print(tableau)
        tableau.tofile(fichier)
        fichier.close()

if __name__ == "__main__":
    ecrit_resultat_nouvelle_methode(python_type=sys.argv[1], nom_methode_osmn_recup=sys.argv[2],
                                    nom_variable_db=sys.argv[3], chemin_vers_data=sys.argv[4])

