/**
 * Cette méthode a pour but de modifier l'état des checkbox de la page ayant pour id "update". Cette nouvelle valeur est
 * la même que la valeur de la check_box entré en paramètre.
 *
 * @param check_box_principal la check_box qui va donner sa valeur à toutes les autres.
 */
function check_toutes_les_autres(check_box_principal) {
    document.querySelectorAll('#update').forEach(check_box => check_box.checked = check_box_principal.checked)
}

/**
 * Cette méthode a pour but de sélectionner le corp (tbody) de la table ayant pour id "form". et de rajouter une ligne
 * "tr" à la table contenant :
 * - une case th avec le label descriptif de la ligne
 * - une case td avec l'entrée texte
 * - une case td ayant un bouton permettant de supprimer cette ligne
 *
 * Dans le cas où nous passons d'un tbody avec une seule ligne à un formulaire de deux lignes nous modifions le text
 * contenue dans le label de la première ligne en "Nom de l'ensemble des communes" :
 */
function ajoute_entre_nom_ville_telechargement_ville(valeur) {
        // récupération du tbody de la table ayant pour id "form"
    tbody = document.getElementById("form").children[0]

    let i = 0
    //modification du texte de la première ligne
    if (tbody.children[i].childElementCount === 1) {
        i = 1
    }
    if ( tbody.childElementCount - 1 === i) {
        tbody.children[i].children[0].firstChild.innerHTML = "Nom de l'ensemble des communes : "
    }

    // création de la nouvelle ligne du tableau
    ligne_tableau = document.createElement("tr")

    //création de la case label de la ligne
    case_label = document.createElement("th")
    var label = document.createElement("label")
    label.innerText = "nom de la ville : "
    label.htmlFor = tbody.firstChild.children[0].firstChild.htmlFor
    case_label.append(label)

    //création de la case entrée texte de la ligne
    case_input = document.createElement("td")
    var input = document.createElement("input");
    input.type = "text";
    input.name = "gvvi_nom_ajout";
    if (valeur !== undefined) {
        input.value = valeur
    }
    case_input.appendChild(input)

    //création de la case du bouton suppression de la ligne
    case_suppression = document.createElement("td")
    var bouton_supprimer = document.createElement("input")
    bouton_supprimer.type = "button"
    bouton_supprimer.value = "supprimmer ville"
    bouton_supprimer.onclick = function() { supprime_entree_nom_ville(bouton_supprimer.parentElement.parentElement.sectionRowIndex); };
    case_suppression.appendChild(bouton_supprimer)

    //ajout de toutes les cases dans la ligne
    ligne_tableau.appendChild(case_label)
    ligne_tableau.appendChild(case_input)
    ligne_tableau.appendChild(case_suppression)

    //ajout de la ligne dans le tableau
    tbody.appendChild(ligne_tableau)
}

/**
 *  Cette méthode a pour but de supprimer la n-ième ligne du corps (tbody) de la table ayant pour id "form".
 *
 * Dans le cas où nous passons d'un tbody avec deux lignes à un formulaire d'une seule ligne nous modifions le text
 * contenue dans le label de la première ligne en "nom de la ville : ".
 *
 * @param n_ieme_ligne_table le numéro de la ligne à supprimer dans la table
 */
function supprime_entree_nom_ville(n_ieme_ligne_table) {
    // récupération du tbody de la table ayant pour id "form"
    tbody = document.getElementById("form").children[0]

    //suppression de la ligne
    tbody.removeChild(tbody.children[n_ieme_ligne_table])

    //modification du texte de la première ligne
    let i = 0
    if (tbody.children[i].childElementCount === 1) {
        i = 1
    }
    if ( tbody.childElementCount - 1 === i) {
        tbody.children[i].children[0].firstChild.innerHTML = "nom de la ville : "
    }
}