import math
from django.test import TestCase
from OSM_outils.OSMnx_recuperation_graph_information import OSMnx_recuperation_graph_information
from OSM_outils.OMSnx_enregistrement import OMSnx_enregistrement

class OSMnx_recuperation_graph_informationTestCase(TestCase):
    """
    Le but de cette classe de test est de vérifier les informations renvoyées depuis la méthode
    recuperation_information_graphe.

    """
    def setUp(self) -> None:
        G = OMSnx_enregistrement.lire_graphe("exemple")
        oSMnx_recuperation_graph_information = OSMnx_recuperation_graph_information(G)
        self.resultat = oSMnx_recuperation_graph_information.recuperation_information_graphe(G)

    def test_intersection_count(self):
        """
        Cette méthode test la valeur calculé pour le nombre d'intersections

        """
        self.assertEqual(self.resultat['gvvi_nb_intersection'], 2)

    def test_get_diametre(self):
        """
        Cette méthode test la valeur retourné par la méthode get_diametre
        """
        self.assertEqual(self.resultat['gvvi_diametre'], 1)

    def test_get_degre_moyen(self):
        """
        Cette méthode permet de tester la valeur retournée par la méthode get_degre_moyen.
        """
        self.assertEqual(self.resultat['gvvi_degre_moyen'], 1)

    def test_get_connectivity(self):
        """
        Cette méthode permet de tester la valeur retournée par la méthode get_connectivity.
        """
        self.assertEqual(self.resultat['gvvi_connectivity'], 1)

    def test_get_planning_vs_self_organised_cities(self):
        """
        Cette méthode permet de tester la valeur retournée par la méthode get_planning_vs_self_organised_cities.
        """
        self.assertEqual(self.resultat['gvvi_org_plan_vs_organized'], 2)

    def test_get_d0_fractal_capacite_dimension(self):
        """
                Cette méthode permet de tester la valeur retournée par la méthode get_d0_fractal_capacite_dimension.
                La valeur comparé est trouvée par l'algorithme de Michele Tirico
        """
        self.assertAlmostEqual(self.resultat['gvvi_d0_fractal_capacite_dimension'], 0)

    def test_get_d1_information_dimension(self):
        """
                Cette méthode permet de tester la valeur retournée par la méthode get_d1_information_dimension.
                La valeur comparé est trouvée par l'algorithme de Michele Tirico
        """
        self.assertAlmostEqual(self.resultat['gvvi_d1_information_dimension'], 0)

    def test_d2_correlation_dimension(self):
        """
                Cette méthode permet de tester la valeur retournée par la méthode d2_correlation_dimension.
                La valeur comparé est trouvée par l'algorithme de Michele Tirico
        """
        self.assertEqual(self.resultat['gvvi_d2_correlation_dimension'], 0)

    def test_get_tree_vs_complete_graph(self):
        """
                Cette méthode permet de tester la valeur retournée par la méthode get_tree_vs_complete_graph.
        """
        self.assertEqual(self.resultat['gvvi_tree_vs_complete_graph'], 0)

    def test_get_longueur_moyennes_rues(self):
        """
                Cette méthode permet de tester la valeur retournée par la méthode get_longueur_moyennes_rues.
        """
        self.assertEqual(self.resultat['gvvi_longueur_moyenne_rues'], 37.271)

    def test_get_robustesse_moyenne(self):
        """
            Cette méthode permet de tester la valeur retournée par get_robustesse_moyenne
        """
        self.assertAlmostEqual(self.resultat['gvvi_robustesse'], 0.5)