import React, { useState } from "react";
import { useMutation, gql } from "@apollo/client";
import { useHistory } from "react-router-dom";

import Logo from './iwocs.png';
import "./../styles/sign-in.css";

const SignIn = () => {
    let history = useHistory();
    const LOGIN_MUTATION = gql`
        mutation login($credentials: LoginInput!) {
            login(credentials: $credentials) {
                userId
                token
                tokenExpiration
            }
        } 
    `;

    const defaultCredentials = {
        email: '',
        password: ''
    };
    const [credentials, setCredentials] = useState({ ...defaultCredentials });
    const [login, { 
        loading: mutationLoading,
        error: mutationError,
        data 
    }] = useMutation(LOGIN_MUTATION, {
        errorPolicy: 'all'
    });

    const onChange = (e) => {
        e.preventDefault();
        const target = e.target;
        const field = target.name;
        
        credentials[`${field}`] = target.value;
        setCredentials({
            ...credentials
        });
    }

    const onSubmit = (e) => {
        e.preventDefault();
        login({ variables: { credentials: credentials }});
        navigateToAnnonce();        
    }
    
    const navigateToAnnonce = () => {
        history.push('/');
    }

    return (
        <div className="text-center">
        <form className="form-signin" onSubmit={onSubmit}>        
            <h1 className="h3 mb-3 font-weight-normal">Connexion</h1>            
                <img className="mb-4" src={Logo} alt="logo iwocs" width="72" height="72"></img>
            <input
                type="email"
                id="inputEmail"
                className="form-control mb-2"
                placeholder="E-mail"
                name="email"
                onChange={onChange}
                required
                autoFocus
            />
            <label htmlFor="inputPassword" className="sr-only">
            Password
            </label>
            <input
                type="password"
                id="inputPassword"
                className="form-control"
                placeholder="Mot de passe"
                name="password"
                onChange={onChange}
                required
            />     
            {mutationError && (
                <div className="alert alert-danger" role="alert">
                    {mutationError.graphQLErrors[0].message}
                </div>
            )}
            <button 
                className="btn btn-lg btn-primary btn-block" 
                type="submit"
                disabled={mutationLoading}
            >
            {mutationLoading ? 
                <div className="spinner-border text-light" role="status">
                    <span className="sr-only">Loading...</span>
                </div>: 'Soumettre'}            
            </button>
            <p className="mt-5 mb-3 text-muted">M2 IWOCS 2020-2021</p>
        </form>
        </div>
  );
};

export default SignIn;
