import React, { useState } from "react";
import { useMutation, gql } from "@apollo/client";

const Register = () => {
    const defaultRegisterInput = {
      username: "",
      email: "",
      password: "",
      avatar: null,
      phone: "",
      address: "",      
    };
    const [registerInput, setRegisterInput] = useState({ ...defaultRegisterInput });

    const SIGNUP_MUTATION = gql`
      mutation signup($data: SignupInput!) {
        signup(data: $data) {
          _id
          username
          email
          phone
          address
          profession
        }
      }
    `;
    const [registerUser, { 
        loading: mutationLoading,
        error: mutationError,
        data 
    }] = useMutation(SIGNUP_MUTATION,  {
        errorPolicy: 'all'
    });

    const onSubmit = (e) => {
        e.preventDefault();
        registerUser({ variables: { data: registerInput } });        
        setRegisterInput(defaultRegisterInput);
    };

    const onChange = e => {
        e.preventDefault();
        const target = e.target;
        const field = target.name;
        let value;
        if (target.type === 'file') {
          const {
            multiple,
            files: [file],
          } = target;
          value = multiple ? target.files : file;
        } else {
            value = target.value;
        }

        registerInput[`${field}`] = value;
        setRegisterInput({
            ...registerInput
        });
    };

  return (
    <div className="signup-form">
      <form onSubmit={onSubmit}>
        <h2>Inscription</h2>
        <p>Veuillez remplir ce formulaire pour créer un compte!</p>
        <hr />
        <div className="form-group">
          <div className="row">
            <div className="col">
              <input
                type="text"
                className="form-control"
                name="username"
                placeholder="Nom d'utilisateur"
                onChange={onChange}
                required
              />
            </div>
            <div className="col">
              <input
                type="email"
                className="form-control"
                name="email"
                placeholder="E-mail"
                onChange={onChange}
                required
              />
            </div>
          </div>
        </div>
        <div className="form-group">
          <div className="row">
            <div className="col">
              <input
                type="type"
                className="form-control"
                name="phone"
                placeholder="Téléphone"
                onChange={onChange}
                required
              />
            </div>
            <div className="col">
              <input
                type="text"
                className="form-control"
                name="address"
                placeholder="Adresse"
                onChange={onChange}
                required
              />
            </div>
          </div>
        </div>
        <div className="form-group">
          <div className="row">
            <div className="col">
              <input
                type="file"
                className="form-control"
                name="avatar"
                placeholder="Avatar"
                onChange={onChange}
                required
              />
            </div>
            <div className="col">
              <input
                type="password"
                className="form-control"
                name="password"
                placeholder="Mot de passe"
                onChange={onChange}
                required
              />
            </div>
          </div>
        </div>
        {mutationError && (
          <div className="alert alert-danger" role="alert">
            {mutationError.graphQLErrors[0].message}
          </div>
        )}
        <div className="form-group">
          <button type="submit" className="btn btn-primary btn-lg" disabled={mutationLoading}>
            {mutationLoading ? (
              <div className="spinner-border text-light" role="status">
                <span className="sr-only">Loading...</span>
              </div>
            ) : (
              "Soumettre"
            )}
          </button>
        </div>
      </form>
    </div>
  );
};

export default Register;
