import React from 'react';

import {
  BrowserRouter as Router,
  Switch,
  Route,
  Link
} from "react-router-dom";

import '../styles/App.css';
import Header from './header'
import ListAnnonce from './list-annonces';
import CreateAnnonce from './createAnnonce';
import DetailAnnonce from './detail-annonce';

import SignIn from './../containers/SignIn';
import Register from './../containers/Register';

function App() {

  return (
    <>
      <Header />
      <Router>
        <div className="container">
          <Switch>
            <Route path="/annonces/create">
              <CreateAnnonce />
            </Route>

            <Route path="/sign-in">
              <SignIn />
            </Route>

            <Route path="/register">
              <Register />
            </Route>

            <Route path="/annonces/:annonceId">
              <DetailAnnonce />
            </Route>

            <Route path="/">
              <ListAnnonce />
            </Route>
          </Switch>
        </div>
      </Router>
    </>
  );
}

export default App;
